#!/bin/bash
###
# @Description: This script checks if the ffmpeg packages are installed, and installs it if it's not.
# @Author: Mauker
# @Year: 2015
###

sudo -v

pkgs='ffmpeg gstreamer0.10-ffmpeg'
pkg='ffmpeg'
repo='mc3man/trusty-media'

add_ppa() {
  grep -h "^deb.*$1" /etc/apt/sources.list.d/* > /dev/null 2>&1
  if [ $? -ne 0 ]
  then
    echo "Adding ppa:$1"
    sudo add-apt-repository -y ppa:$1
    return 0
  fi

  echo "ppa:$1 already exists"
  return 1
}

#for pkg in $pkgs; do
echo "Checking if $pkg is installed."
dpkg --get-selections | grep "^$pkg[[:space:]]*install$"
if dpkg --get-selections | grep -q "^$pkg[[:space:]]*install$" >/dev/null; then
	echo "$pkg is installed!"
else
	echo "$pkg is not installed!"
	echo "Checking if repository $repo is configured..."
	if apt-cache policy | grep -q "$repoCheck" > /dev/null; then
		echo "Repository is configured!"
	else
		echo "Repository is not configured! Configuring..."
		add_ppa $repo
		echo "Done."
	fi
                sudo apt-get update -q
                sudo apt-get install -y $pkgs
fi
#done
