/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.antlr;

import com.espertech.esper.epl.expression.ExprNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTUtil {
    private static Log log = LogFactory.getLog(ASTUtil.class);
    private static final String PROPERTY_ENABLED_AST_DUMP = "ENABLE_AST_DUMP";

    public static Tree findFirstNode(Tree parent, int type) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree child = parent.getChild(i);
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    public static void dumpAST(Tree ast) {
        if (System.getProperty(PROPERTY_ENABLED_AST_DUMP) != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ASTUtil.renderNode(new char[0], ast, printer);
            ASTUtil.dumpAST(printer, ast, 2);
            log.info(".dumpAST ANTLR Tree dump follows...\n" + writer.toString());
        }
    }

    private static void dumpAST(PrintWriter printer, Tree ast, int ident) {
        char[] identChars = new char[ident];
        Arrays.fill(identChars, ' ');
        if (ast == null) {
            ASTUtil.renderNode(identChars, null, printer);
            return;
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            Tree node = ast.getChild(i);
            if (node == null) {
                throw new NullPointerException("Null AST node");
            }
            ASTUtil.renderNode(identChars, node, printer);
            ASTUtil.dumpAST(printer, node, ident + 2);
        }
    }

    public static void printTokens(CommonTokenStream tokens2) {
        if (log.isDebugEnabled()) {
            List tokenList = tokens2.getTokens();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            for (int i = 0; i < tokens2.size(); ++i) {
                Token t = (Token)tokenList.get(i);
                String text = t.getText();
                if (text.trim().length() == 0) {
                    printer.print("'" + text + "'");
                } else {
                    printer.print(text);
                }
                printer.print('[');
                printer.print(t.getType());
                printer.print(']');
                printer.print(" ");
            }
            printer.println();
            log.debug("Tokens: " + writer.toString());
        }
    }

    private static void renderNode(char[] ident, Tree node, PrintWriter printer) {
        printer.print(ident);
        if (node == null) {
            printer.print("NULL NODE");
        } else {
            printer.print(node.getText());
            printer.print(" [");
            printer.print(node.getType());
            printer.print("]");
            if (node.getText() == null) {
                printer.print(" (null value in text)");
            } else if (node.getText().contains("\\")) {
                int count = 0;
                for (int i = 0; i < node.getText().length(); ++i) {
                    if (node.getText().charAt(i) != '\\') continue;
                    ++count;
                }
                printer.print(" (" + count + " backlashes)");
            }
        }
        printer.println();
    }

    public static ExprNode getRemoveExpr(Tree child, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode thisEvalNode = astExprNodeMap.get(child);
        astExprNodeMap.remove(child);
        return thisEvalNode;
    }
}

