/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.soda.StreamSelector;
import java.io.Serializable;

public class ConfigurationEngineDefaults
implements Serializable {
    private Threading threading = new Threading();
    private ViewResources viewResources = new ViewResources();
    private EventMeta eventMeta = new EventMeta();
    private Logging logging = new Logging();
    private Variables variables = new Variables();
    private StreamSelection streamSelection = new StreamSelection();
    private TimeSource timeSource = new TimeSource();
    private Language language;
    private Expression expression;
    private Execution execution;
    private ConfigurationMetricsReporting metricsReporting = new ConfigurationMetricsReporting();
    private AlternativeContext alternativeContext;
    private static final long serialVersionUID = -528835191586154300L;

    protected ConfigurationEngineDefaults() {
        this.language = new Language();
        this.expression = new Expression();
        this.execution = new Execution();
        this.alternativeContext = new AlternativeContext();
    }

    public Threading getThreading() {
        return this.threading;
    }

    public ViewResources getViewResources() {
        return this.viewResources;
    }

    public EventMeta getEventMeta() {
        return this.eventMeta;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public StreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public ConfigurationMetricsReporting getMetricsReporting() {
        return this.metricsReporting;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public AlternativeContext getAlternativeContext() {
        return this.alternativeContext;
    }

    public void setAlternativeContext(AlternativeContext alternativeContext) {
        this.alternativeContext = alternativeContext;
    }

    public static class AlternativeContext
    implements Serializable {
        private static final long serialVersionUID = 4488861684585251042L;
        private String runtime;
        private String admin;

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public String getAdmin() {
            return this.admin;
        }

        public void setAdmin(String admin) {
            this.admin = admin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeSourceType {
        MILLI,
        NANO;

    }

    public static class Execution
    implements Serializable {
        private boolean prioritized = false;
        private static final long serialVersionUID = 0L;

        protected Execution() {
        }

        public boolean isPrioritized() {
            return this.prioritized;
        }

        public void setPrioritized(boolean prioritized) {
            this.prioritized = prioritized;
        }
    }

    public static class Expression
    implements Serializable {
        private static final long serialVersionUID = 3192205923560011213L;
        private boolean integerDivision = false;
        private boolean divisionByZeroReturnsNull = false;
        private boolean udfCache = true;
        private boolean selfSubselectPreeval = true;
        private boolean extendedAggregation = true;

        public boolean isIntegerDivision() {
            return this.integerDivision;
        }

        public void setIntegerDivision(boolean integerDivision) {
            this.integerDivision = integerDivision;
        }

        public boolean isDivisionByZeroReturnsNull() {
            return this.divisionByZeroReturnsNull;
        }

        public void setDivisionByZeroReturnsNull(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        public boolean isUdfCache() {
            return this.udfCache;
        }

        public void setUdfCache(boolean udfCache) {
            this.udfCache = udfCache;
        }

        public boolean isSelfSubselectPreeval() {
            return this.selfSubselectPreeval;
        }

        public void setSelfSubselectPreeval(boolean selfSubselectPreeval) {
            this.selfSubselectPreeval = selfSubselectPreeval;
        }

        public boolean isExtendedAggregation() {
            return this.extendedAggregation;
        }

        public void setExtendedAggregation(boolean extendedAggregation) {
            this.extendedAggregation = extendedAggregation;
        }
    }

    public static class Language
    implements Serializable {
        private boolean sortUsingCollator = false;
        private static final long serialVersionUID = -6237674558477894392L;

        public boolean isSortUsingCollator() {
            return this.sortUsingCollator;
        }

        public void setSortUsingCollator(boolean sortUsingCollator) {
            this.sortUsingCollator = sortUsingCollator;
        }
    }

    public static class TimeSource
    implements Serializable {
        private TimeSourceType timeSourceType = TimeSourceType.MILLI;
        private static final long serialVersionUID = 2075039404763313824L;

        public TimeSourceType getTimeSourceType() {
            return this.timeSourceType;
        }

        public void setTimeSourceType(TimeSourceType timeSourceType) {
            this.timeSourceType = timeSourceType;
        }
    }

    public static class StreamSelection
    implements Serializable {
        private StreamSelector defaultStreamSelector = StreamSelector.ISTREAM_ONLY;
        private static final long serialVersionUID = -7943748323859161674L;

        protected StreamSelection() {
        }

        public StreamSelector getDefaultStreamSelector() {
            return this.defaultStreamSelector;
        }

        public void setDefaultStreamSelector(StreamSelector defaultStreamSelector) {
            this.defaultStreamSelector = defaultStreamSelector;
        }
    }

    public static class Variables
    implements Serializable {
        private long msecVersionRelease = 15000L;
        private static final long serialVersionUID = 8276015152830052323L;

        protected Variables() {
        }

        public long getMsecVersionRelease() {
            return this.msecVersionRelease;
        }

        public void setMsecVersionRelease(long msecVersionRelease) {
            this.msecVersionRelease = msecVersionRelease;
        }
    }

    public static class Logging
    implements Serializable {
        private boolean enableExecutionDebug = false;
        private boolean enableTimerDebug = true;
        private static final long serialVersionUID = -8129836306582810327L;

        protected Logging() {
        }

        public boolean isEnableExecutionDebug() {
            return this.enableExecutionDebug;
        }

        public void setEnableExecutionDebug(boolean enableExecutionDebug) {
            this.enableExecutionDebug = enableExecutionDebug;
        }

        public boolean isEnableTimerDebug() {
            return this.enableTimerDebug;
        }

        public void setEnableTimerDebug(boolean enableTimerDebug) {
            this.enableTimerDebug = enableTimerDebug;
        }
    }

    public static class EventMeta
    implements Serializable {
        private static final long serialVersionUID = -6091772368103140370L;
        private Configuration.PropertyResolutionStyle classPropertyResolutionStyle = Configuration.PropertyResolutionStyle.getDefault();
        private ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle = ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN;

        public ConfigurationEventTypeLegacy.AccessorStyle getDefaultAccessorStyle() {
            return this.defaultAccessorStyle;
        }

        public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
            this.defaultAccessorStyle = defaultAccessorStyle;
        }

        public Configuration.PropertyResolutionStyle getClassPropertyResolutionStyle() {
            return this.classPropertyResolutionStyle;
        }

        public void setClassPropertyResolutionStyle(Configuration.PropertyResolutionStyle classPropertyResolutionStyle) {
            this.classPropertyResolutionStyle = classPropertyResolutionStyle;
        }
    }

    public static class ViewResources
    implements Serializable {
        private boolean shareViews = true;
        private boolean allowMultipleExpiryPolicies = false;
        private static final long serialVersionUID = 2527853225433208362L;

        protected ViewResources() {
        }

        public boolean isShareViews() {
            return this.shareViews;
        }

        public void setShareViews(boolean shareViews) {
            this.shareViews = shareViews;
        }

        public boolean isAllowMultipleExpiryPolicies() {
            return this.allowMultipleExpiryPolicies;
        }

        public void setAllowMultipleExpiryPolicies(boolean allowMultipleExpiryPolicies) {
            this.allowMultipleExpiryPolicies = allowMultipleExpiryPolicies;
        }
    }

    public static class Threading
    implements Serializable {
        private boolean isListenerDispatchPreserveOrder = true;
        private long listenerDispatchTimeout = 1000L;
        private Locking listenerDispatchLocking = Locking.SPIN;
        private boolean isInsertIntoDispatchPreserveOrder = true;
        private long insertIntoDispatchTimeout = 100L;
        private Locking insertIntoDispatchLocking = Locking.SPIN;
        private long internalTimerMsecResolution = 100L;
        private boolean internalTimerEnabled = true;
        private static final long serialVersionUID = 6504606101119059962L;
        private boolean isThreadPoolTimerExec = false;
        private boolean isThreadPoolInbound = false;
        private boolean isThreadPoolRouteExec = false;
        private boolean isThreadPoolOutbound = false;
        private int threadPoolTimerExecNumThreads = 2;
        private int threadPoolInboundNumThreads = 2;
        private int threadPoolRouteExecNumThreads = 2;
        private int threadPoolOutboundNumThreads = 2;
        private Integer threadPoolTimerExecCapacity;
        private Integer threadPoolInboundCapacity;
        private Integer threadPoolRouteExecCapacity;
        private Integer threadPoolOutboundCapacity;

        public void setListenerDispatchPreserveOrder(boolean value) {
            this.isListenerDispatchPreserveOrder = value;
        }

        public void setListenerDispatchTimeout(long value) {
            this.listenerDispatchTimeout = value;
        }

        public void setInsertIntoDispatchPreserveOrder(boolean value) {
            this.isInsertIntoDispatchPreserveOrder = value;
        }

        public boolean isListenerDispatchPreserveOrder() {
            return this.isListenerDispatchPreserveOrder;
        }

        public long getListenerDispatchTimeout() {
            return this.listenerDispatchTimeout;
        }

        public boolean isInsertIntoDispatchPreserveOrder() {
            return this.isInsertIntoDispatchPreserveOrder;
        }

        public void setInternalTimerEnabled(boolean internalTimerEnabled) {
            this.internalTimerEnabled = internalTimerEnabled;
        }

        public boolean isInternalTimerEnabled() {
            return this.internalTimerEnabled;
        }

        public long getInternalTimerMsecResolution() {
            return this.internalTimerMsecResolution;
        }

        public void setInternalTimerMsecResolution(long internalTimerMsecResolution) {
            this.internalTimerMsecResolution = internalTimerMsecResolution;
        }

        public long getInsertIntoDispatchTimeout() {
            return this.insertIntoDispatchTimeout;
        }

        public void setListenerDispatchLocking(Locking listenerDispatchLocking) {
            this.listenerDispatchLocking = listenerDispatchLocking;
        }

        public void setInsertIntoDispatchTimeout(long msecTimeout) {
            this.insertIntoDispatchTimeout = msecTimeout;
        }

        public void setInsertIntoDispatchLocking(Locking insertIntoDispatchLocking) {
            this.insertIntoDispatchLocking = insertIntoDispatchLocking;
        }

        public Locking getListenerDispatchLocking() {
            return this.listenerDispatchLocking;
        }

        public Locking getInsertIntoDispatchLocking() {
            return this.insertIntoDispatchLocking;
        }

        public boolean isThreadPoolInbound() {
            return this.isThreadPoolInbound;
        }

        public void setThreadPoolInbound(boolean threadPoolInbound) {
            this.isThreadPoolInbound = threadPoolInbound;
        }

        public boolean isThreadPoolTimerExec() {
            return this.isThreadPoolTimerExec;
        }

        public void setThreadPoolTimerExec(boolean threadPoolTimerExec) {
            this.isThreadPoolTimerExec = threadPoolTimerExec;
        }

        public boolean isThreadPoolRouteExec() {
            return this.isThreadPoolRouteExec;
        }

        public void setThreadPoolRouteExec(boolean threadPoolRouteExec) {
            this.isThreadPoolRouteExec = threadPoolRouteExec;
        }

        public boolean isThreadPoolOutbound() {
            return this.isThreadPoolOutbound;
        }

        public void setThreadPoolOutbound(boolean threadPoolOutbound) {
            this.isThreadPoolOutbound = threadPoolOutbound;
        }

        public int getThreadPoolInboundNumThreads() {
            return this.threadPoolInboundNumThreads;
        }

        public void setThreadPoolInboundNumThreads(int num) {
            this.threadPoolInboundNumThreads = num;
        }

        public int getThreadPoolOutboundNumThreads() {
            return this.threadPoolOutboundNumThreads;
        }

        public void setThreadPoolOutboundNumThreads(int num) {
            this.threadPoolOutboundNumThreads = num;
        }

        public int getThreadPoolRouteExecNumThreads() {
            return this.threadPoolRouteExecNumThreads;
        }

        public void setThreadPoolRouteExecNumThreads(int num) {
            this.threadPoolRouteExecNumThreads = num;
        }

        public int getThreadPoolTimerExecNumThreads() {
            return this.threadPoolTimerExecNumThreads;
        }

        public void setThreadPoolTimerExecNumThreads(int num) {
            this.threadPoolTimerExecNumThreads = num;
        }

        public Integer getThreadPoolTimerExecCapacity() {
            return this.threadPoolTimerExecCapacity;
        }

        public void setThreadPoolTimerExecCapacity(Integer capacity) {
            this.threadPoolTimerExecCapacity = capacity;
        }

        public Integer getThreadPoolInboundCapacity() {
            return this.threadPoolInboundCapacity;
        }

        public void setThreadPoolInboundCapacity(Integer capacity) {
            this.threadPoolInboundCapacity = capacity;
        }

        public Integer getThreadPoolRouteExecCapacity() {
            return this.threadPoolRouteExecCapacity;
        }

        public void setThreadPoolRouteExecCapacity(Integer capacity) {
            this.threadPoolRouteExecCapacity = capacity;
        }

        public Integer getThreadPoolOutboundCapacity() {
            return this.threadPoolOutboundCapacity;
        }

        public void setThreadPoolOutboundCapacity(Integer capacity) {
            this.threadPoolOutboundCapacity = capacity;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Locking {
            SPIN,
            SUSPEND;

        }
    }
}

