/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationCacheReferenceType;
import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.soda.StreamSelector;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.type.StringPatternSetLike;
import com.espertech.esper.type.StringPatternSetRegex;
import com.espertech.esper.util.DOMElementIterator;
import com.espertech.esper.util.JavaClassHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ConfigurationParser {
    private static Log log = LogFactory.getLog(ConfigurationParser.class);

    ConfigurationParser() {
    }

    protected static void doConfigure(Configuration configuration, InputStream stream, String resourceName) throws EPException {
        Document document = ConfigurationParser.getDocument(stream, resourceName);
        ConfigurationParser.doConfigure(configuration, document);
    }

    protected static Document getDocument(InputStream stream, String resourceName) throws EPException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (ParserConfigurationException ex) {
            throw new EPException("Could not get a DOM parser configuration: " + resourceName, ex);
        }
        catch (SAXException ex) {
            throw new EPException("Could not parse configuration: " + resourceName, ex);
        }
        catch (IOException ex) {
            throw new EPException("Could not read configuration: " + resourceName, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn("could not close input stream for: " + resourceName, ioe);
            }
        }
        return document;
    }

    protected static void doConfigure(Configuration configuration, Document doc) throws EPException {
        Element root = doc.getDocumentElement();
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(root.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("event-type-auto-name")) {
                ConfigurationParser.handleEventTypeAutoNames(configuration, element);
                continue;
            }
            if (nodeName.equals("event-type")) {
                ConfigurationParser.handleEventTypes(configuration, element);
                continue;
            }
            if (nodeName.equals("auto-import")) {
                ConfigurationParser.handleAutoImports(configuration, element);
                continue;
            }
            if (nodeName.equals("method-reference")) {
                ConfigurationParser.handleMethodReference(configuration, element);
                continue;
            }
            if (nodeName.equals("database-reference")) {
                ConfigurationParser.handleDatabaseRefs(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-view")) {
                ConfigurationParser.handlePlugInView(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-aggregation-function")) {
                ConfigurationParser.handlePlugInAggregation(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-guard")) {
                ConfigurationParser.handlePlugInPatternGuard(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-observer")) {
                ConfigurationParser.handlePlugInPatternObserver(configuration, element);
                continue;
            }
            if (nodeName.equals("variable")) {
                ConfigurationParser.handleVariable(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-loader")) {
                ConfigurationParser.handlePluginLoaders(configuration, element);
                continue;
            }
            if (nodeName.equals("engine-settings")) {
                ConfigurationParser.handleEngineSettings(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-representation")) {
                ConfigurationParser.handlePlugInEventRepresentation(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-type")) {
                ConfigurationParser.handlePlugInEventType(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-type-name-resolution")) {
                ConfigurationParser.handlePlugIneventTypeNameResolution(configuration, element);
                continue;
            }
            if (nodeName.equals("revision-event-type")) {
                ConfigurationParser.handleRevisionEventType(configuration, element);
                continue;
            }
            if (!nodeName.equals("variant-stream")) continue;
            ConfigurationParser.handleVariantStream(configuration, element);
        }
    }

    private static void handleEventTypeAutoNames(Configuration configuration, Element element) {
        String name = element.getAttributes().getNamedItem("package-name").getTextContent();
        configuration.addEventTypeAutoName(name);
    }

    private static void handleEventTypes(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        Node classNode = element.getAttributes().getNamedItem("class");
        String optionalClassName = null;
        if (classNode != null) {
            optionalClassName = classNode.getTextContent();
            configuration.addEventType(name, optionalClassName);
        }
        ConfigurationParser.handleEventTypeDef(name, optionalClassName, configuration, element);
    }

    private static void handleEventTypeDef(String name, String optionalClassName, Configuration configuration, Node parentNode) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(parentNode.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element eventTypeElement = eventTypeNodeIterator.next();
            String nodeName = eventTypeElement.getNodeName();
            if (nodeName.equals("xml-dom")) {
                ConfigurationParser.handleXMLDOM(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("java-util-map")) {
                ConfigurationParser.handleMap(name, configuration, eventTypeElement);
                continue;
            }
            if (!nodeName.equals("legacy-type")) continue;
            ConfigurationParser.handleLegacy(name, optionalClassName, configuration, eventTypeElement);
        }
    }

    private static void handleMap(String name, Configuration configuration, Element eventTypeElement) {
        Node superTypesList = eventTypeElement.getAttributes().getNamedItem("supertype-names");
        if (superTypesList != null) {
            String[] names;
            String value = superTypesList.getTextContent();
            for (String superTypeName : names = value.split(",")) {
                configuration.addMapSuperType(name, superTypeName.trim());
            }
        }
        Properties propertyTypeNames = new Properties();
        NodeList propertyList = eventTypeElement.getElementsByTagName("map-property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String nameProperty = propertyList.item(i).getAttributes().getNamedItem("name").getTextContent();
            String clazz = propertyList.item(i).getAttributes().getNamedItem("class").getTextContent();
            propertyTypeNames.put(nameProperty, clazz);
        }
        configuration.addEventType(name, propertyTypeNames);
    }

    private static void handleXMLDOM(String name, Configuration configuration, Element xmldomElement) {
        String rootElementName = xmldomElement.getAttributes().getNamedItem("root-element-name").getTextContent();
        String rootElementNamespace = ConfigurationParser.getOptionalAttribute(xmldomElement, "root-element-namespace");
        String schemaResource = ConfigurationParser.getOptionalAttribute(xmldomElement, "schema-resource");
        String defaultNamespace = ConfigurationParser.getOptionalAttribute(xmldomElement, "default-namespace");
        String resolvePropertiesAbsoluteStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-resolve-properties-absolute");
        String propertyExprXPathStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-property-expr");
        String eventSenderChecksRootStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "event-sender-validates-root");
        String xpathFunctionResolverClass = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-function-resolver");
        String xpathVariableResolverClass = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-variable-resolver");
        String autoFragmentStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "auto-fragment");
        ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc = new ConfigurationEventTypeXMLDOM();
        xmlDOMEventTypeDesc.setRootElementName(rootElementName);
        xmlDOMEventTypeDesc.setSchemaResource(schemaResource);
        xmlDOMEventTypeDesc.setRootElementNamespace(rootElementNamespace);
        xmlDOMEventTypeDesc.setDefaultNamespace(defaultNamespace);
        xmlDOMEventTypeDesc.setXPathFunctionResolver(xpathFunctionResolverClass);
        xmlDOMEventTypeDesc.setXPathVariableResolver(xpathVariableResolverClass);
        if (resolvePropertiesAbsoluteStr != null) {
            xmlDOMEventTypeDesc.setXPathResolvePropertiesAbsolute(Boolean.parseBoolean(resolvePropertiesAbsoluteStr));
        }
        if (propertyExprXPathStr != null) {
            xmlDOMEventTypeDesc.setXPathPropertyExpr(Boolean.parseBoolean(propertyExprXPathStr));
        }
        if (eventSenderChecksRootStr != null) {
            xmlDOMEventTypeDesc.setEventSenderValidatesRoot(Boolean.parseBoolean(eventSenderChecksRootStr));
        }
        if (autoFragmentStr != null) {
            xmlDOMEventTypeDesc.setAutoFragment(Boolean.parseBoolean(autoFragmentStr));
        }
        configuration.addEventType(name, xmlDOMEventTypeDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            QName xpathConstantType;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("namespace-prefix")) {
                String prefix = propertyElement.getAttributes().getNamedItem("prefix").getTextContent();
                String namespace2 = propertyElement.getAttributes().getNamedItem("namespace").getTextContent();
                xmlDOMEventTypeDesc.addNamespacePrefix(prefix, namespace2);
            }
            if (!propertyElement.getNodeName().equals("xpath-property")) continue;
            String propertyName = propertyElement.getAttributes().getNamedItem("property-name").getTextContent();
            String xPath = propertyElement.getAttributes().getNamedItem("xpath").getTextContent();
            String propertyType = propertyElement.getAttributes().getNamedItem("type").getTextContent();
            if (propertyType.toUpperCase().equals("NUMBER")) {
                xpathConstantType = XPathConstants.NUMBER;
            } else if (propertyType.toUpperCase().equals("STRING")) {
                xpathConstantType = XPathConstants.STRING;
            } else if (propertyType.toUpperCase().equals("BOOLEAN")) {
                xpathConstantType = XPathConstants.BOOLEAN;
            } else if (propertyType.toUpperCase().equals("NODE")) {
                xpathConstantType = XPathConstants.NODE;
            } else if (propertyType.toUpperCase().equals("NODESET")) {
                xpathConstantType = XPathConstants.NODESET;
            } else {
                throw new IllegalArgumentException("Invalid xpath property type for property '" + propertyName + "' and type '" + propertyType + '\'');
            }
            String castToClass = null;
            if (propertyElement.getAttributes().getNamedItem("cast") != null) {
                castToClass = propertyElement.getAttributes().getNamedItem("cast").getTextContent();
            }
            String optionaleventTypeName = null;
            if (propertyElement.getAttributes().getNamedItem("event-type-name") != null) {
                optionaleventTypeName = propertyElement.getAttributes().getNamedItem("event-type-name").getTextContent();
            }
            if (optionaleventTypeName != null) {
                xmlDOMEventTypeDesc.addXPathPropertyFragment(propertyName, xPath, xpathConstantType, optionaleventTypeName);
                continue;
            }
            xmlDOMEventTypeDesc.addXPathProperty(propertyName, xPath, xpathConstantType, castToClass);
        }
    }

    private static void handleLegacy(String name, String className, Configuration configuration, Element xmldomElement) {
        if (className == null) {
            throw new ConfigurationException("Required class name not supplied for legacy type definition");
        }
        String accessorStyle = xmldomElement.getAttributes().getNamedItem("accessor-style").getTextContent();
        String codeGeneration = xmldomElement.getAttributes().getNamedItem("code-generation").getTextContent();
        String propertyResolution = xmldomElement.getAttributes().getNamedItem("property-resolution-style").getTextContent();
        String factoryMethod = ConfigurationParser.getOptionalAttribute(xmldomElement, "factory-method");
        String copyMethod = ConfigurationParser.getOptionalAttribute(xmldomElement, "copy-method");
        ConfigurationEventTypeLegacy legacyDesc = new ConfigurationEventTypeLegacy();
        if (accessorStyle != null) {
            legacyDesc.setAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle.valueOf(accessorStyle.toUpperCase()));
        }
        if (codeGeneration != null) {
            legacyDesc.setCodeGeneration(ConfigurationEventTypeLegacy.CodeGeneration.valueOf(codeGeneration.toUpperCase()));
        }
        if (propertyResolution != null) {
            legacyDesc.setPropertyResolutionStyle(Configuration.PropertyResolutionStyle.valueOf(propertyResolution.toUpperCase()));
        }
        if (factoryMethod != null) {
            legacyDesc.setFactoryMethod(factoryMethod);
        }
        if (copyMethod != null) {
            legacyDesc.setCopyMethod(copyMethod);
        }
        configuration.addEventType(name, className, legacyDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            String nameProperty;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("method-property")) {
                nameProperty = propertyElement.getAttributes().getNamedItem("name").getTextContent();
                String method = propertyElement.getAttributes().getNamedItem("accessor-method").getTextContent();
                legacyDesc.addMethodProperty(nameProperty, method);
                continue;
            }
            if (propertyElement.getNodeName().equals("field-property")) {
                nameProperty = propertyElement.getAttributes().getNamedItem("name").getTextContent();
                String field = propertyElement.getAttributes().getNamedItem("accessor-field").getTextContent();
                legacyDesc.addFieldProperty(nameProperty, field);
                continue;
            }
            throw new ConfigurationException("Invalid node " + propertyElement.getNodeName() + " encountered while parsing legacy type definition");
        }
    }

    private static void handleAutoImports(Configuration configuration, Element element) {
        String name = element.getAttributes().getNamedItem("import-name").getTextContent();
        configuration.addImport(name);
    }

    private static void handleDatabaseRefs(Configuration configuration, Element element) {
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        ConfigurationDBRef configDBRef = new ConfigurationDBRef();
        configuration.addDatabaseReference(name, configDBRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Enum parsed;
            String value;
            String className;
            Properties properties;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("datasource-connection")) {
                String lookup = subElement.getAttributes().getNamedItem("context-lookup-name").getTextContent();
                properties = ConfigurationParser.handleProperties(subElement, "env-property");
                configDBRef.setDataSourceConnection(lookup, properties);
            }
            if (subElement.getNodeName().equals("datasourcefactory-connection")) {
                className = subElement.getAttributes().getNamedItem("class-name").getTextContent();
                properties = ConfigurationParser.handleProperties(subElement, "env-property");
                configDBRef.setDataSourceFactory(properties, className);
                continue;
            }
            if (subElement.getNodeName().equals("drivermanager-connection")) {
                className = subElement.getAttributes().getNamedItem("class-name").getTextContent();
                String url = subElement.getAttributes().getNamedItem("url").getTextContent();
                String userName = subElement.getAttributes().getNamedItem("user").getTextContent();
                String password = subElement.getAttributes().getNamedItem("password").getTextContent();
                Properties properties2 = ConfigurationParser.handleProperties(subElement, "connection-arg");
                configDBRef.setDriverManagerConnection(className, url, userName, password, properties2);
                continue;
            }
            if (subElement.getNodeName().equals("connection-lifecycle")) {
                value = subElement.getAttributes().getNamedItem("value").getTextContent();
                configDBRef.setConnectionLifecycleEnum(ConfigurationDBRef.ConnectionLifecycleEnum.valueOf(value.toUpperCase()));
                continue;
            }
            if (subElement.getNodeName().equals("connection-settings")) {
                if (subElement.getAttributes().getNamedItem("auto-commit") != null) {
                    String autoCommit = subElement.getAttributes().getNamedItem("auto-commit").getTextContent();
                    configDBRef.setConnectionAutoCommit(Boolean.parseBoolean(autoCommit));
                }
                if (subElement.getAttributes().getNamedItem("transaction-isolation") != null) {
                    String transactionIsolation = subElement.getAttributes().getNamedItem("transaction-isolation").getTextContent();
                    configDBRef.setConnectionTransactionIsolation(Integer.parseInt(transactionIsolation));
                }
                if (subElement.getAttributes().getNamedItem("catalog") != null) {
                    String catalog = subElement.getAttributes().getNamedItem("catalog").getTextContent();
                    configDBRef.setConnectionCatalog(catalog);
                }
                if (subElement.getAttributes().getNamedItem("read-only") == null) continue;
                String readOnly = subElement.getAttributes().getNamedItem("read-only").getTextContent();
                configDBRef.setConnectionReadOnly(Boolean.parseBoolean(readOnly));
                continue;
            }
            if (subElement.getNodeName().equals("column-change-case")) {
                value = subElement.getAttributes().getNamedItem("value").getTextContent();
                parsed = ConfigurationDBRef.ColumnChangeCaseEnum.valueOf(value.toUpperCase());
                configDBRef.setColumnChangeCase((ConfigurationDBRef.ColumnChangeCaseEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("metadata-origin")) {
                value = subElement.getAttributes().getNamedItem("value").getTextContent();
                parsed = ConfigurationDBRef.MetadataOriginEnum.valueOf(value.toUpperCase());
                configDBRef.setMetadataOrigin((ConfigurationDBRef.MetadataOriginEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("sql-types-mapping")) {
                Integer sqlTypeInt;
                String sqlType = subElement.getAttributes().getNamedItem("sql-type").getTextContent();
                String javaType = subElement.getAttributes().getNamedItem("java-type").getTextContent();
                try {
                    sqlTypeInt = Integer.parseInt(sqlType);
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("Error converting sql type '" + sqlType + "' to integer java.sql.Types constant");
                }
                configDBRef.addSqlTypesBinding((int)sqlTypeInt, javaType);
                continue;
            }
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = subElement.getAttributes().getNamedItem("max-age-seconds").getTextContent();
                String purgeInterval = subElement.getAttributes().getNamedItem("purge-interval-seconds").getTextContent();
                ConfigurationCacheReferenceType refTypeEnum = ConfigurationCacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = ConfigurationCacheReferenceType.valueOf(refType.toUpperCase());
                }
                configDBRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = subElement.getAttributes().getNamedItem("size").getTextContent();
            configDBRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handleMethodReference(Configuration configuration, Element element) {
        String className = element.getAttributes().getNamedItem("class-name").getTextContent();
        ConfigurationMethodRef configMethodRef = new ConfigurationMethodRef();
        configuration.addMethodRef(className, configMethodRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = subElement.getAttributes().getNamedItem("max-age-seconds").getTextContent();
                String purgeInterval = subElement.getAttributes().getNamedItem("purge-interval-seconds").getTextContent();
                ConfigurationCacheReferenceType refTypeEnum = ConfigurationCacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = ConfigurationCacheReferenceType.valueOf(refType.toUpperCase());
                }
                configMethodRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = subElement.getAttributes().getNamedItem("size").getTextContent();
            configMethodRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handlePlugInView(Configuration configuration, Element element) {
        String namespace2 = element.getAttributes().getNamedItem("namespace").getTextContent();
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String factoryClassName = element.getAttributes().getNamedItem("factory-class").getTextContent();
        configuration.addPlugInView(namespace2, name, factoryClassName);
    }

    private static void handlePlugInAggregation(Configuration configuration, Element element) {
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String functionClassName = element.getAttributes().getNamedItem("function-class").getTextContent();
        configuration.addPlugInAggregationFunction(name, functionClassName);
    }

    private static void handlePlugInPatternGuard(Configuration configuration, Element element) {
        String namespace2 = element.getAttributes().getNamedItem("namespace").getTextContent();
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String factoryClassName = element.getAttributes().getNamedItem("factory-class").getTextContent();
        configuration.addPlugInPatternGuard(namespace2, name, factoryClassName);
    }

    private static void handlePlugInPatternObserver(Configuration configuration, Element element) {
        String namespace2 = element.getAttributes().getNamedItem("namespace").getTextContent();
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String factoryClassName = element.getAttributes().getNamedItem("factory-class").getTextContent();
        configuration.addPlugInPatternObserver(namespace2, name, factoryClassName);
    }

    private static void handleVariable(Configuration configuration, Element element) {
        String variableName = element.getAttributes().getNamedItem("name").getTextContent();
        String type = element.getAttributes().getNamedItem("type").getTextContent();
        Class variableType = JavaClassHelper.getClassForSimpleName(type);
        if (variableType == null) {
            throw new ConfigurationException("Invalid variable type for variable '" + variableName + "', the type is not recognized");
        }
        Node initValueNode = element.getAttributes().getNamedItem("initialization-value");
        String initValue = null;
        if (initValueNode != null) {
            initValue = initValueNode.getTextContent();
        }
        configuration.addVariable(variableName, variableType, (Object)initValue);
    }

    private static void handlePluginLoaders(Configuration configuration, Element element) {
        String loaderName = element.getAttributes().getNamedItem("name").getTextContent();
        String className = element.getAttributes().getNamedItem("class-name").getTextContent();
        Properties properties = new Properties();
        String configXML = null;
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("init-arg")) {
                String name = subElement.getAttributes().getNamedItem("name").getTextContent();
                String value = subElement.getAttributes().getNamedItem("value").getTextContent();
                properties.put(name, value);
            }
            if (!subElement.getNodeName().equals("config-xml")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e2) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "' :" + e2.getMessage(), e2);
            }
            configXML = output.toString();
        }
        configuration.addPluginLoader(loaderName, className, properties, configXML);
    }

    private static void handlePlugInEventRepresentation(Configuration configuration, Element element) {
        URI uriParsed;
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        String uri = element.getAttributes().getNamedItem("uri").getTextContent();
        String className = element.getAttributes().getNamedItem("class-name").getTextContent();
        String initializer = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("initializer")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling initializer for plug-in event representation '" + uri + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e2) {
                throw new ConfigurationException("Error handling initializer for plug-in event representation '" + uri + "' :" + e2.getMessage(), e2);
            }
            initializer = output.toString();
        }
        try {
            uriParsed = new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException("Error parsing URI '" + uri + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
        }
        configuration.addPlugInEventRepresentation(uriParsed, className, (Serializable)((Object)initializer));
    }

    private static void handlePlugInEventType(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        ArrayList<URI> uris = new ArrayList<URI>();
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String initializer = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("resolution-uri")) {
                URI uri;
                String uriValue = subElement.getAttributes().getNamedItem("value").getTextContent();
                try {
                    uri = new URI(uriValue);
                }
                catch (URISyntaxException ex) {
                    throw new ConfigurationException("Error parsing URI '" + uriValue + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
                }
                uris.add(uri);
            }
            if (!subElement.getNodeName().equals("initializer")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling initializer for plug-in event type '" + name + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e2) {
                throw new ConfigurationException("Error handling initializer for plug-in event type '" + name + "' :" + e2.getMessage(), e2);
            }
            initializer = output.toString();
        }
        configuration.addPlugInEventType(name, uris.toArray(new URI[uris.size()]), (Serializable)((Object)initializer));
    }

    private static void handlePlugIneventTypeNameResolution(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        ArrayList<URI> uris = new ArrayList<URI>();
        while (nodeIterator.hasNext()) {
            URI uri;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("resolution-uri")) continue;
            String uriValue = subElement.getAttributes().getNamedItem("value").getTextContent();
            try {
                uri = new URI(uriValue);
            }
            catch (URISyntaxException ex) {
                throw new ConfigurationException("Error parsing URI '" + uriValue + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
            }
            uris.add(uri);
        }
        configuration.setPlugInEventTypeResolutionURIs(uris.toArray(new URI[uris.size()]));
    }

    private static void handleRevisionEventType(Configuration configuration, Element element) {
        ConfigurationRevisionEventType revEventType = new ConfigurationRevisionEventType();
        String revTypeName = element.getAttributes().getNamedItem("name").getTextContent();
        if (element.getAttributes().getNamedItem("property-revision") != null) {
            String propertyRevision = element.getAttributes().getNamedItem("property-revision").getTextContent();
            try {
                ConfigurationRevisionEventType.PropertyRevision propertyRevisionEnum = ConfigurationRevisionEventType.PropertyRevision.valueOf(propertyRevision.trim().toUpperCase());
                revEventType.setPropertyRevision(propertyRevisionEnum);
            }
            catch (RuntimeException ex) {
                throw new ConfigurationException("Invalid enumeration value for property-revision attribute '" + propertyRevision + "'");
            }
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        HashSet<String> keyProperties = new HashSet<String>();
        while (nodeIterator.hasNext()) {
            String name;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("base-event-type")) {
                name = subElement.getAttributes().getNamedItem("name").getTextContent();
                revEventType.addNameBaseEventType(name);
            }
            if (subElement.getNodeName().equals("delta-event-type")) {
                name = subElement.getAttributes().getNamedItem("name").getTextContent();
                revEventType.addNameDeltaEventType(name);
            }
            if (!subElement.getNodeName().equals("key-property")) continue;
            name = subElement.getAttributes().getNamedItem("name").getTextContent();
            keyProperties.add(name);
        }
        String[] keyProps = keyProperties.toArray(new String[keyProperties.size()]);
        revEventType.setKeyPropertyNames(keyProps);
        configuration.addRevisionEventType(revTypeName, revEventType);
    }

    private static void handleVariantStream(Configuration configuration, Element element) {
        ConfigurationVariantStream variantStream = new ConfigurationVariantStream();
        String varianceName = element.getAttributes().getNamedItem("name").getTextContent();
        if (element.getAttributes().getNamedItem("type-variance") != null) {
            String typeVar = element.getAttributes().getNamedItem("type-variance").getTextContent();
            try {
                ConfigurationVariantStream.TypeVariance typeVarianceEnum = ConfigurationVariantStream.TypeVariance.valueOf(typeVar.trim().toUpperCase());
                variantStream.setTypeVariance(typeVarianceEnum);
            }
            catch (RuntimeException ex) {
                throw new ConfigurationException("Invalid enumeration value for type-variance attribute '" + typeVar + "'");
            }
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("variant-event-type")) continue;
            String name = subElement.getAttributes().getNamedItem("name").getTextContent();
            variantStream.addEventTypeName(name);
        }
        configuration.addVariantStream(varianceName, variantStream);
    }

    private static void handleEngineSettings(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("defaults")) continue;
            ConfigurationParser.handleEngineSettingsDefaults(configuration, subElement);
        }
    }

    private static void handleEngineSettingsDefaults(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("threading")) {
                ConfigurationParser.handleDefaultsThreading(configuration, subElement);
            }
            if (subElement.getNodeName().equals("event-meta")) {
                ConfigurationParser.handleDefaultsEventMeta(configuration, subElement);
            }
            if (subElement.getNodeName().equals("view-resources")) {
                ConfigurationParser.handleDefaultsViewResources(configuration, subElement);
            }
            if (subElement.getNodeName().equals("logging")) {
                ConfigurationParser.handleDefaultsLogging(configuration, subElement);
            }
            if (subElement.getNodeName().equals("variables")) {
                ConfigurationParser.handleDefaultsVariables(configuration, subElement);
            }
            if (subElement.getNodeName().equals("stream-selection")) {
                ConfigurationParser.handleDefaultsStreamSelection(configuration, subElement);
            }
            if (subElement.getNodeName().equals("time-source")) {
                ConfigurationParser.handleDefaultsTimeSource(configuration, subElement);
            }
            if (subElement.getNodeName().equals("metrics-reporting")) {
                ConfigurationParser.handleMetricsReporting(configuration, subElement);
            }
            if (subElement.getNodeName().equals("language")) {
                ConfigurationParser.handleLanguage(configuration, subElement);
            }
            if (subElement.getNodeName().equals("expression")) {
                ConfigurationParser.handleExpression(configuration, subElement);
            }
            if (!subElement.getNodeName().equals("execution")) continue;
            ConfigurationParser.handleExecution(configuration, subElement);
        }
    }

    private static void handleDefaultsThreading(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            ThreadPoolConfig result;
            String value;
            Long timeoutMSec;
            String timeoutMSecText;
            Boolean preserveOrder;
            String preserveOrderText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("listener-dispatch")) {
                preserveOrderText = subElement.getAttributes().getNamedItem("preserve-order").getTextContent();
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                configuration.getEngineDefaults().getThreading().setListenerDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    configuration.getEngineDefaults().getThreading().setListenerDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    configuration.getEngineDefaults().getThreading().setListenerDispatchLocking(ConfigurationEngineDefaults.Threading.Locking.valueOf(value.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("insert-into-dispatch")) {
                preserveOrderText = subElement.getAttributes().getNamedItem("preserve-order").getTextContent();
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                configuration.getEngineDefaults().getThreading().setInsertIntoDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    configuration.getEngineDefaults().getThreading().setInsertIntoDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    configuration.getEngineDefaults().getThreading().setInsertIntoDispatchLocking(ConfigurationEngineDefaults.Threading.Locking.valueOf(value.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("internal-timer")) {
                String enabledText = subElement.getAttributes().getNamedItem("enabled").getTextContent();
                Boolean enabled = Boolean.parseBoolean(enabledText);
                String msecResolutionText = subElement.getAttributes().getNamedItem("msec-resolution").getTextContent();
                Long msecResolution = Long.parseLong(msecResolutionText);
                configuration.getEngineDefaults().getThreading().setInternalTimerEnabled(enabled);
                configuration.getEngineDefaults().getThreading().setInternalTimerMsecResolution(msecResolution);
            }
            if (subElement.getNodeName().equals("threadpool-inbound")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolInbound(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolInboundNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolInboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-outbound")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolOutbound(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolOutboundNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolOutboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-timerexec")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExec(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExecNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExecCapacity(result.getCapacity());
            }
            if (!subElement.getNodeName().equals("threadpool-routeexec")) continue;
            result = ConfigurationParser.parseThreadPoolConfig(subElement);
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExec(result.isEnabled());
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExecNumThreads(result.getNumThreads());
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExecCapacity(result.getCapacity());
        }
    }

    private static ThreadPoolConfig parseThreadPoolConfig(Element parentElement) {
        String enabled = ConfigurationParser.getRequiredAttribute(parentElement, "enabled");
        boolean isEnabled = Boolean.parseBoolean(enabled);
        String numThreadsStr = ConfigurationParser.getRequiredAttribute(parentElement, "num-threads");
        int numThreads = Integer.parseInt(numThreadsStr);
        String capacityStr = ConfigurationParser.getOptionalAttribute(parentElement, "capacity");
        Integer capacity = null;
        if (capacityStr != null) {
            capacity = Integer.parseInt(capacityStr);
        }
        return new ThreadPoolConfig(isEnabled, numThreads, capacity);
    }

    private static void handleDefaultsViewResources(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("share-views")) {
                valueText = subElement.getAttributes().getNamedItem("enabled").getTextContent();
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getViewResources().setShareViews(value);
            }
            if (!subElement.getNodeName().equals("allow-multiple-expiry-policy")) continue;
            valueText = subElement.getAttributes().getNamedItem("enabled").getTextContent();
            value = Boolean.parseBoolean(valueText);
            configuration.getEngineDefaults().getViewResources().setAllowMultipleExpiryPolicies(value);
        }
    }

    private static void handleDefaultsLogging(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("execution-path")) {
                valueText = subElement.getAttributes().getNamedItem("enabled").getTextContent();
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getLogging().setEnableExecutionDebug(value);
            }
            if (!subElement.getNodeName().equals("timer-debug")) continue;
            valueText = subElement.getAttributes().getNamedItem("enabled").getTextContent();
            value = Boolean.parseBoolean(valueText);
            configuration.getEngineDefaults().getLogging().setEnableTimerDebug(value);
        }
    }

    private static void handleDefaultsVariables(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("msec-version-release")) continue;
            String valueText = subElement.getAttributes().getNamedItem("value").getTextContent();
            Long value = Long.parseLong(valueText);
            configuration.getEngineDefaults().getVariables().setMsecVersionRelease(value);
        }
    }

    private static void handleDefaultsStreamSelection(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            StreamSelector defaultSelector;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stream-selector")) continue;
            String valueText = subElement.getAttributes().getNamedItem("value").getTextContent();
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for stream-selector element");
            }
            if (valueText.toUpperCase().trim().equals("ISTREAM")) {
                defaultSelector = StreamSelector.ISTREAM_ONLY;
            } else if (valueText.toUpperCase().trim().equals("RSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ONLY;
            } else if (valueText.toUpperCase().trim().equals("IRSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ISTREAM_BOTH;
            } else {
                throw new ConfigurationException("Value attribute for stream-selector element invalid, expected one of the following keywords: istream, irstream, rstream");
            }
            configuration.getEngineDefaults().getStreamSelection().setDefaultStreamSelector(defaultSelector);
        }
    }

    private static void handleDefaultsTimeSource(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            ConfigurationEngineDefaults.TimeSourceType timeSourceType;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("time-source-type")) continue;
            String valueText = subElement.getAttributes().getNamedItem("value").getTextContent();
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for time-source element");
            }
            if (valueText.toUpperCase().trim().equals("NANO")) {
                timeSourceType = ConfigurationEngineDefaults.TimeSourceType.NANO;
            } else if (valueText.toUpperCase().trim().equals("MILLI")) {
                timeSourceType = ConfigurationEngineDefaults.TimeSourceType.MILLI;
            } else {
                throw new ConfigurationException("Value attribute for time-source element invalid, expected one of the following keywords: nano, milli");
            }
            configuration.getEngineDefaults().getTimeSource().setTimeSourceType(timeSourceType);
        }
    }

    private static void handleMetricsReporting(Configuration configuration, Element parentElement) {
        String threading;
        String statementInterval;
        String enabled = ConfigurationParser.getRequiredAttribute(parentElement, "enabled");
        boolean isEnabled = Boolean.parseBoolean(enabled);
        configuration.getEngineDefaults().getMetricsReporting().setEnableMetricsReporting(isEnabled);
        String engineInterval = ConfigurationParser.getOptionalAttribute(parentElement, "engine-interval");
        if (engineInterval != null) {
            configuration.getEngineDefaults().getMetricsReporting().setEngineInterval(Long.parseLong(engineInterval));
        }
        if ((statementInterval = ConfigurationParser.getOptionalAttribute(parentElement, "statement-interval")) != null) {
            configuration.getEngineDefaults().getMetricsReporting().setStatementInterval(Long.parseLong(statementInterval));
        }
        if ((threading = ConfigurationParser.getOptionalAttribute(parentElement, "threading")) != null) {
            configuration.getEngineDefaults().getMetricsReporting().setThreading(Boolean.parseBoolean(threading));
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            String reportInactive;
            String numStmts;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stmtgroup")) continue;
            String name = ConfigurationParser.getRequiredAttribute(subElement, "name");
            long interval = Long.parseLong(ConfigurationParser.getRequiredAttribute(subElement, "interval"));
            ConfigurationMetricsReporting.StmtGroupMetrics metrics = new ConfigurationMetricsReporting.StmtGroupMetrics();
            metrics.setInterval(interval);
            configuration.getEngineDefaults().getMetricsReporting().addStmtGroup(name, metrics);
            String defaultInclude = ConfigurationParser.getOptionalAttribute(subElement, "default-include");
            if (defaultInclude != null) {
                metrics.setDefaultInclude(Boolean.parseBoolean(defaultInclude));
            }
            if ((numStmts = ConfigurationParser.getOptionalAttribute(subElement, "num-stmts")) != null) {
                metrics.setNumStatements(Integer.parseInt(numStmts));
            }
            if ((reportInactive = ConfigurationParser.getOptionalAttribute(subElement, "report-inactive")) != null) {
                metrics.setReportInactive(Boolean.parseBoolean(reportInactive));
            }
            ConfigurationParser.handleMetricsReportingPatterns(metrics, subElement);
        }
    }

    private static void handleLanguage(Configuration configuration, Element parentElement) {
        String sortUsingCollator = ConfigurationParser.getOptionalAttribute(parentElement, "sort-using-collator");
        if (sortUsingCollator != null) {
            boolean isSortUsingCollator = Boolean.parseBoolean(sortUsingCollator);
            configuration.getEngineDefaults().getLanguage().setSortUsingCollator(isSortUsingCollator);
        }
    }

    private static void handleExpression(Configuration configuration, Element parentElement) {
        String extendedAggregationStr;
        String selfSubselectPreeval;
        String udfCache;
        String divZero;
        String integerDivision = ConfigurationParser.getOptionalAttribute(parentElement, "integer-division");
        if (integerDivision != null) {
            boolean isIntegerDivision = Boolean.parseBoolean(integerDivision);
            configuration.getEngineDefaults().getExpression().setIntegerDivision(isIntegerDivision);
        }
        if ((divZero = ConfigurationParser.getOptionalAttribute(parentElement, "division-by-zero-is-null")) != null) {
            boolean isDivZero = Boolean.parseBoolean(divZero);
            configuration.getEngineDefaults().getExpression().setDivisionByZeroReturnsNull(isDivZero);
        }
        if ((udfCache = ConfigurationParser.getOptionalAttribute(parentElement, "udf-cache")) != null) {
            boolean isUdfCache = Boolean.parseBoolean(udfCache);
            configuration.getEngineDefaults().getExpression().setUdfCache(isUdfCache);
        }
        if ((selfSubselectPreeval = ConfigurationParser.getOptionalAttribute(parentElement, "self-subselect-preeval")) != null) {
            boolean isSelfSubselectPreeval = Boolean.parseBoolean(selfSubselectPreeval);
            configuration.getEngineDefaults().getExpression().setSelfSubselectPreeval(isSelfSubselectPreeval);
        }
        if ((extendedAggregationStr = ConfigurationParser.getOptionalAttribute(parentElement, "extended-agg")) != null) {
            boolean extendedAggregation = Boolean.parseBoolean(extendedAggregationStr);
            configuration.getEngineDefaults().getExpression().setExtendedAggregation(extendedAggregation);
        }
    }

    private static void handleExecution(Configuration configuration, Element parentElement) {
        String prioritizedStr = ConfigurationParser.getOptionalAttribute(parentElement, "prioritized");
        if (prioritizedStr != null) {
            boolean isPrioritized = Boolean.parseBoolean(prioritizedStr);
            configuration.getEngineDefaults().getExecution().setPrioritized(isPrioritized);
        }
    }

    private static void handleMetricsReportingPatterns(ConfigurationMetricsReporting.StmtGroupMetrics groupDef, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            String text;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("include-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), true));
            }
            if (subElement.getNodeName().equals("exclude-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), false));
            }
            if (subElement.getNodeName().equals("include-like")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), true));
            }
            if (!subElement.getNodeName().equals("exclude-like")) continue;
            text = subElement.getChildNodes().item(0).getTextContent();
            groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), false));
        }
    }

    private static void handleDefaultsEventMeta(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Node accessorStyleNode;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("class-property-resolution")) continue;
            Node styleNode = subElement.getAttributes().getNamedItem("style");
            if (styleNode != null) {
                String styleText = styleNode.getTextContent();
                Configuration.PropertyResolutionStyle value = Configuration.PropertyResolutionStyle.valueOf(styleText.toUpperCase());
                configuration.getEngineDefaults().getEventMeta().setClassPropertyResolutionStyle(value);
            }
            if ((accessorStyleNode = subElement.getAttributes().getNamedItem("accessor-style")) == null) continue;
            String accessorStyleText = accessorStyleNode.getTextContent();
            ConfigurationEventTypeLegacy.AccessorStyle value = ConfigurationEventTypeLegacy.AccessorStyle.valueOf(accessorStyleText.toUpperCase());
            configuration.getEngineDefaults().getEventMeta().setDefaultAccessorStyle(value);
        }
    }

    private static Properties handleProperties(Element element, String propElementName) {
        Properties properties = new Properties();
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals(propElementName)) continue;
            String name = subElement.getAttributes().getNamedItem("name").getTextContent();
            String value = subElement.getAttributes().getNamedItem("value").getTextContent();
            properties.put(name, value);
        }
        return properties;
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = ConfigurationParser.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = ConfigurationParser.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new EPException(resource + " not found");
        }
        return stream;
    }

    private static String getOptionalAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode != null) {
            return valueNode.getTextContent();
        }
        return null;
    }

    private static String getRequiredAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode == null) {
            throw new ConfigurationException("Required attribute by name '" + key + "' not found");
        }
        return valueNode.getTextContent();
    }

    private static class ThreadPoolConfig {
        private boolean enabled;
        private int numThreads;
        private Integer capacity;

        public ThreadPoolConfig(boolean enabled, int numThreads, Integer capacity) {
            this.enabled = enabled;
            this.numThreads = numThreads;
            this.capacity = capacity;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public Integer getCapacity() {
            return this.capacity;
        }
    }
}

