/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class ArithmaticExpression
extends ExpressionBase {
    private static final long serialVersionUID = 2237615280620839719L;
    private String operator;

    public ArithmaticExpression() {
    }

    public ArithmaticExpression(String operator) {
        this.operator = operator;
    }

    public ArithmaticExpression(Expression left, String operator, Expression right) {
        this.operator = operator;
        this.addChild(left);
        this.addChild(right);
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public ArithmaticExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public ArithmaticExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public ArithmaticExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    public ExpressionPrecedenceEnum getPrecedence() {
        if (this.operator.equals("*") || this.operator.equals("/") || this.operator.equals("%")) {
            return ExpressionPrecedenceEnum.MULTIPLY;
        }
        return ExpressionPrecedenceEnum.ADDITIVE;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        for (Expression child : this.getChildren()) {
            writer.write(delimiter);
            child.toEPL(writer, this.getPrecedence());
            delimiter = " " + this.operator + " ";
        }
    }
}

