/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIndexClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String indexName;
    private String windowName;
    private List<String> columns = new ArrayList<String>();

    public CreateIndexClause() {
    }

    public static CreateIndexClause create(String indexName, String windowName, String ... properties) {
        return new CreateIndexClause(indexName, windowName, properties);
    }

    public CreateIndexClause(String indexName, String windowName, String[] properties) {
        this.indexName = indexName;
        this.windowName = windowName;
        this.columns.addAll(Arrays.asList(properties));
    }

    public void toEPL(StringWriter writer) {
        writer.write("create index ");
        writer.write(this.indexName);
        writer.write(" on ");
        writer.write(this.windowName);
        writer.write(40);
        String delimiter = "";
        for (String prop : this.columns) {
            writer.write(delimiter);
            writer.write(prop);
            delimiter = ", ";
        }
        writer.write(41);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }
}

