/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.ProjectedStream;
import com.espertech.esper.client.soda.SelectClause;
import com.espertech.esper.client.soda.SelectClauseElement;
import com.espertech.esper.client.soda.SelectClauseExpression;
import com.espertech.esper.client.soda.View;
import com.espertech.esper.util.JavaClassHelper;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWindowClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private List<View> views;
    private boolean insert;
    private Expression insertWhereClause;

    public CreateWindowClause() {
    }

    public static CreateWindowClause create(String windowName, View view) {
        return new CreateWindowClause(windowName, new View[]{view});
    }

    public static CreateWindowClause create(String windowName, View ... views) {
        return new CreateWindowClause(windowName, views);
    }

    public CreateWindowClause addView(String namespace2, String name) {
        this.views.add(View.create(namespace2, name));
        return this;
    }

    public CreateWindowClause addView(String namespace2, String name, List<Expression> parameters) {
        this.views.add(View.create(namespace2, name, parameters));
        return this;
    }

    public CreateWindowClause addView(String namespace2, String name, Expression ... parameters) {
        this.views.add(View.create(namespace2, name, parameters));
        return this;
    }

    public CreateWindowClause(String windowName, View[] viewArr) {
        this.windowName = windowName;
        this.views = new ArrayList<View>();
        if (viewArr != null) {
            this.views.addAll(Arrays.asList(viewArr));
        }
    }

    public CreateWindowClause(String windowName, List<View> views) {
        this.windowName = windowName;
        this.views = views;
    }

    public void toEPL(StringWriter writer) {
        writer.write("create window ");
        writer.write(this.windowName);
        ProjectedStream.toEPLViews(writer, this.views);
    }

    public void toEPLInsertPart(StringWriter writer) {
        if (this.insert) {
            writer.write(" insert");
            if (this.insertWhereClause != null) {
                writer.write(" where ");
                this.insertWhereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            }
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<View> getViews() {
        return this.views;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public boolean getInsert() {
        return this.insert;
    }

    public Expression getInsertWhereClause() {
        return this.insertWhereClause;
    }

    public CreateWindowClause insert(boolean insert) {
        this.insert = insert;
        return this;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public CreateWindowClause insertWhereClause(Expression insertWhereClause) {
        this.insertWhereClause = insertWhereClause;
        return this;
    }

    public void setInsertWhereClause(Expression insertWhereClause) {
        this.insertWhereClause = insertWhereClause;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public void toEPLCreateTablePart(StringWriter writer, SelectClause selectClause) {
        writer.write(40);
        String delimiter = "";
        for (SelectClauseElement element : selectClause.getSelectList()) {
            Class clazz;
            SelectClauseExpression expr;
            if (!(element instanceof SelectClauseExpression) || !((expr = (SelectClauseExpression)element).getExpression() instanceof ConstantExpression)) continue;
            ConstantExpression constant = (ConstantExpression)expr.getExpression();
            try {
                clazz = JavaClassHelper.getClassForName(constant.getConstantType());
            }
            catch (ClassNotFoundException e2) {
                continue;
            }
            writer.write(delimiter);
            writer.append(expr.getAsName());
            writer.write(32);
            writer.append(clazz.getSimpleName().toLowerCase());
            delimiter = ", ";
        }
        writer.write(41);
    }
}

