/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EPBaseNamedObject
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String namespace;
    private String name;
    private List<Expression> parameters;

    public EPBaseNamedObject() {
    }

    public EPBaseNamedObject(String namespace2, String name, List<Expression> parameters) {
        this.namespace = namespace2;
        this.name = name;
        this.parameters = parameters;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace2) {
        this.namespace = namespace2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }

    public void toEPL(StringWriter writer) {
        writer.write(this.namespace);
        writer.write(58);
        writer.write(this.name);
        String delimiter = "";
        writer.write(40);
        for (Expression param : this.parameters) {
            writer.write(delimiter);
            param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.write(41);
    }
}

