/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.CreateIndexClause;
import com.espertech.esper.client.soda.CreateSchemaClause;
import com.espertech.esper.client.soda.CreateVariableClause;
import com.espertech.esper.client.soda.CreateWindowClause;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.FilterStream;
import com.espertech.esper.client.soda.ForClause;
import com.espertech.esper.client.soda.FromClause;
import com.espertech.esper.client.soda.GroupByClause;
import com.espertech.esper.client.soda.InsertIntoClause;
import com.espertech.esper.client.soda.MatchRecognizeClause;
import com.espertech.esper.client.soda.OnClause;
import com.espertech.esper.client.soda.OnDeleteClause;
import com.espertech.esper.client.soda.OnInsertSplitStreamClause;
import com.espertech.esper.client.soda.OnSelectClause;
import com.espertech.esper.client.soda.OnSetClause;
import com.espertech.esper.client.soda.OnUpdateClause;
import com.espertech.esper.client.soda.OrderByClause;
import com.espertech.esper.client.soda.OutputLimitClause;
import com.espertech.esper.client.soda.RowLimitClause;
import com.espertech.esper.client.soda.SelectClause;
import com.espertech.esper.client.soda.UpdateClause;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPStatementObjectModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<AnnotationPart> annotations;
    private UpdateClause updateClause;
    private CreateVariableClause createVariable;
    private CreateWindowClause createWindow;
    private CreateIndexClause createIndex;
    private CreateSchemaClause createSchema;
    private OnClause onExpr;
    private InsertIntoClause insertInto;
    private SelectClause selectClause;
    private FromClause fromClause;
    private Expression whereClause;
    private GroupByClause groupByClause;
    private Expression havingClause;
    private OutputLimitClause outputLimitClause;
    private OrderByClause orderByClause;
    private RowLimitClause rowLimitClause;
    private MatchRecognizeClause matchRecognizeClause;
    private ForClause forClause;

    public void setInsertInto(InsertIntoClause insertInto) {
        this.insertInto = insertInto;
    }

    public EPStatementObjectModel insertInto(InsertIntoClause insertInto) {
        this.insertInto = insertInto;
        return this;
    }

    public InsertIntoClause getInsertInto() {
        return this.insertInto;
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public EPStatementObjectModel selectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public EPStatementObjectModel fromClause(FromClause fromClause) {
        this.fromClause = fromClause;
        return this;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public EPStatementObjectModel whereClause(Expression whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public GroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
    }

    public EPStatementObjectModel groupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
        return this;
    }

    public Expression getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(Expression havingClause) {
        this.havingClause = havingClause;
    }

    public EPStatementObjectModel havingClause(Expression havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public EPStatementObjectModel orderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public OutputLimitClause getOutputLimitClause() {
        return this.outputLimitClause;
    }

    public void setOutputLimitClause(OutputLimitClause outputLimitClause) {
        this.outputLimitClause = outputLimitClause;
    }

    public EPStatementObjectModel outputLimitClause(OutputLimitClause outputLimitClause) {
        this.outputLimitClause = outputLimitClause;
        return this;
    }

    public String toEPL() {
        StringWriter writer = new StringWriter();
        AnnotationPart.toEPL(writer, this.annotations);
        if (this.createIndex != null) {
            this.createIndex.toEPL(writer);
            return writer.toString();
        }
        if (this.createSchema != null) {
            this.createSchema.toEPL(writer);
            return writer.toString();
        }
        if (this.createWindow != null) {
            this.createWindow.toEPL(writer);
            if (this.fromClause == null) {
                throw new IllegalStateException("From clause has not been defined");
            }
            FilterStream fs = (FilterStream)this.fromClause.getStreams().get(0);
            if (fs.isRetainUnion()) {
                writer.write(" retain-union");
            }
            writer.write(" as ");
            if (this.selectClause == null) {
                throw new IllegalStateException("Select clause has not been defined");
            }
            if (fs.getFilter().getEventTypeName().equals(Object.class.getName())) {
                this.createWindow.toEPLCreateTablePart(writer, this.selectClause);
            } else {
                this.selectClause.toEPL(writer);
                this.fromClause.toEPL(writer);
                this.createWindow.toEPLInsertPart(writer);
            }
            return writer.toString();
        }
        if (this.createVariable != null) {
            this.createVariable.toEPL(writer);
            return writer.toString();
        }
        boolean displayWhereClause = true;
        if (this.updateClause != null) {
            this.updateClause.toEPL(writer);
        } else if (this.onExpr != null) {
            writer.write("on ");
            this.fromClause.getStreams().get(0).toEPL(writer);
            if (this.onExpr instanceof OnDeleteClause) {
                writer.write(" delete from ");
                ((OnDeleteClause)this.onExpr).toEPL(writer);
            } else if (this.onExpr instanceof OnUpdateClause) {
                writer.write(" update ");
                ((OnUpdateClause)this.onExpr).toEPL(writer);
            } else if (this.onExpr instanceof OnSelectClause) {
                writer.write(" ");
                if (this.insertInto != null) {
                    this.insertInto.toEPL(writer);
                }
                this.selectClause.toEPL(writer);
                writer.write(" from ");
                ((OnSelectClause)this.onExpr).toEPL(writer);
            } else if (this.onExpr instanceof OnSetClause) {
                OnSetClause onSet = (OnSetClause)this.onExpr;
                onSet.toEPL(writer);
            } else {
                OnInsertSplitStreamClause split = (OnInsertSplitStreamClause)this.onExpr;
                writer.write(" ");
                this.insertInto.toEPL(writer);
                this.selectClause.toEPL(writer);
                if (this.whereClause != null) {
                    writer.write(" where ");
                    this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                }
                writer.write(" ");
                split.toEPL(writer);
                displayWhereClause = false;
            }
        } else {
            if (this.selectClause == null) {
                throw new IllegalStateException("Select-clause has not been defined");
            }
            if (this.fromClause == null) {
                throw new IllegalStateException("From-clause has not been defined");
            }
            if (this.insertInto != null) {
                this.insertInto.toEPL(writer);
            }
            this.selectClause.toEPL(writer);
            this.fromClause.toEPL(writer);
        }
        if (this.matchRecognizeClause != null) {
            this.matchRecognizeClause.toEPL(writer);
        }
        if (this.whereClause != null && displayWhereClause) {
            writer.write(" where ");
            this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (this.groupByClause != null) {
            writer.write(" group by ");
            this.groupByClause.toEPL(writer);
        }
        if (this.havingClause != null) {
            writer.write(" having ");
            this.havingClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (this.outputLimitClause != null) {
            writer.write(" output ");
            this.outputLimitClause.toEPL(writer);
        }
        if (this.orderByClause != null) {
            writer.write(" order by ");
            this.orderByClause.toEPL(writer);
        }
        if (this.rowLimitClause != null) {
            writer.write(" limit ");
            this.rowLimitClause.toEPL(writer);
        }
        if (this.forClause != null) {
            this.forClause.toEPL(writer);
        }
        return writer.toString();
    }

    public CreateWindowClause getCreateWindow() {
        return this.createWindow;
    }

    public void setCreateWindow(CreateWindowClause createWindow) {
        this.createWindow = createWindow;
    }

    public OnClause getOnExpr() {
        return this.onExpr;
    }

    public void setOnExpr(OnClause onExpr) {
        this.onExpr = onExpr;
    }

    public CreateVariableClause getCreateVariable() {
        return this.createVariable;
    }

    public void setCreateVariable(CreateVariableClause createVariable) {
        this.createVariable = createVariable;
    }

    public RowLimitClause getRowLimitClause() {
        return this.rowLimitClause;
    }

    public void setRowLimitClause(RowLimitClause rowLimitClause) {
        this.rowLimitClause = rowLimitClause;
    }

    public UpdateClause getUpdateClause() {
        return this.updateClause;
    }

    public void setUpdateClause(UpdateClause updateClause) {
        this.updateClause = updateClause;
    }

    public List<AnnotationPart> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationPart> annotations) {
        this.annotations = annotations;
    }

    public MatchRecognizeClause getMatchRecognizeClause() {
        return this.matchRecognizeClause;
    }

    public void setMatchRecognizeClause(MatchRecognizeClause clause) {
        this.matchRecognizeClause = clause;
    }

    public CreateIndexClause getCreateIndex() {
        return this.createIndex;
    }

    public void setCreateIndex(CreateIndexClause createIndex) {
        this.createIndex = createIndex;
    }

    public CreateSchemaClause getCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(CreateSchemaClause createSchema) {
        this.createSchema = createSchema;
    }

    public ForClause getForClause() {
        return this.forClause;
    }

    public void setForClause(ForClause forClause) {
        this.forClause = forClause;
    }
}

