/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.StreamSelector;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertIntoClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean insertStream;
    private String streamName;
    private List<String> columnNames;

    public InsertIntoClause() {
    }

    public static InsertIntoClause create(String streamName) {
        return new InsertIntoClause(streamName);
    }

    public static InsertIntoClause create(String streamName, String ... columns) {
        return new InsertIntoClause(streamName, columns);
    }

    public static InsertIntoClause create(String streamName, String[] columns, StreamSelector streamSelector) {
        if (streamSelector == StreamSelector.RSTREAM_ISTREAM_BOTH) {
            throw new IllegalArgumentException("Insert into only allows istream or rstream selection, not both");
        }
        return new InsertIntoClause(streamName, Arrays.asList(columns), streamSelector != StreamSelector.RSTREAM_ONLY);
    }

    public InsertIntoClause(String streamName) {
        this.insertStream = true;
        this.streamName = streamName;
        this.columnNames = new ArrayList<String>();
    }

    public InsertIntoClause(String streamName, String[] columnNames) {
        this.insertStream = true;
        this.streamName = streamName;
        this.columnNames = Arrays.asList(columnNames);
    }

    public InsertIntoClause(String streamName, List<String> columnNames, boolean isIStream) {
        this.insertStream = isIStream;
        this.streamName = streamName;
        this.columnNames = columnNames;
    }

    public boolean isInsertStream() {
        return this.insertStream;
    }

    public void setInsertStream(boolean insertStream) {
        this.insertStream = insertStream;
    }

    public boolean isIStream() {
        return this.insertStream;
    }

    public boolean getIStream() {
        return this.insertStream;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setIStream(boolean IStream2) {
        this.insertStream = IStream2;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void add(String columnName) {
        this.columnNames.add(columnName);
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void toEPL(StringWriter writer) {
        writer.write("insert ");
        if (!this.insertStream) {
            writer.write("rstream ");
        }
        writer.write("into ");
        writer.write(this.streamName);
        if (this.columnNames.size() > 0) {
            writer.write("(");
            String delimiter = "";
            for (String name : this.columnNames) {
                writer.write(delimiter);
                writer.write(name);
                delimiter = ", ";
            }
            writer.write(")");
        }
        writer.write(32);
    }
}

