/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnClause;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnUpdateClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private String optionalAsName;
    private List<AssignmentPair> assignments;

    public OnUpdateClause() {
        this.assignments = new ArrayList<AssignmentPair>();
    }

    public static OnUpdateClause create(String windowName, String optionalAsName) {
        return new OnUpdateClause(windowName, optionalAsName);
    }

    public OnUpdateClause(String windowName, String optionalAsName) {
        this.windowName = windowName;
        this.optionalAsName = optionalAsName;
        this.assignments = new ArrayList<AssignmentPair>();
    }

    public void toEPL(StringWriter writer) {
        writer.write(this.windowName);
        if (this.optionalAsName != null) {
            writer.write(" as ");
            writer.write(this.optionalAsName);
        }
        writer.write(" set ");
        String delimiter = "";
        for (AssignmentPair pair : this.assignments) {
            writer.write(delimiter);
            writer.write(pair.getName());
            writer.write(" = ");
            pair.getValue().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public String getOptionalAsName() {
        return this.optionalAsName;
    }

    public void setOptionalAsName(String optionalAsName) {
        this.optionalAsName = optionalAsName;
    }

    public OnUpdateClause addAssignment(String variable, Expression expression) {
        this.assignments.add(new AssignmentPair(variable, expression));
        return this;
    }

    public List<AssignmentPair> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<AssignmentPair> assignments) {
        this.assignments = assignments;
    }
}

