/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternExprBase;
import com.espertech.esper.client.soda.PatternExprPrecedenceEnum;
import java.io.StringWriter;

public class PatternMatchUntilExpr
extends PatternExprBase {
    private Integer low;
    private Integer high;
    private static final long serialVersionUID = -427123340111619016L;

    public PatternMatchUntilExpr() {
    }

    public PatternMatchUntilExpr(Integer low, Integer high) {
        this.low = low;
        this.high = high;
    }

    public PatternMatchUntilExpr(Integer low, Integer high, PatternExpr match, PatternExpr until) {
        this.low = low;
        this.high = high;
        this.addChild(match);
        this.addChild(until);
    }

    public Integer getLow() {
        return this.low;
    }

    public void setLow(Integer low) {
        this.low = low;
    }

    public Integer getHigh() {
        return this.high;
    }

    public void setHigh(Integer high) {
        this.high = high;
    }

    public PatternExprPrecedenceEnum getPrecedence() {
        return PatternExprPrecedenceEnum.MATCH_UNTIL;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.low != null || this.high != null) {
            writer.write("[");
            if (this.low != null && this.high != null) {
                if (this.low.equals(this.high)) {
                    writer.write(Integer.toString(this.low));
                } else {
                    writer.write(Integer.toString(this.low));
                    writer.write("..");
                    writer.write(Integer.toString(this.high));
                }
            } else if (this.low != null) {
                writer.write(Integer.toString(this.low));
                writer.write("..");
            } else {
                writer.write("..");
                writer.write(Integer.toString(this.high));
            }
            writer.write("] ");
        }
        PatternExprPrecedenceEnum precedence = this.getPrecedence();
        if (this.getChildren().get(0) instanceof PatternMatchUntilExpr) {
            precedence = PatternExprPrecedenceEnum.MAXIMIM;
        }
        this.getChildren().get(0).toEPL(writer, precedence);
        if (this.getChildren().size() > 1) {
            writer.write(" until ");
            this.getChildren().get(1).toEPL(writer, this.getPrecedence());
        }
    }
}

