/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class PlugInProjectionExpression
extends ExpressionBase {
    private String functionName;
    private boolean isDistinct;
    private static final long serialVersionUID = -4474825377733541468L;

    public PlugInProjectionExpression() {
    }

    public PlugInProjectionExpression(String functionName, boolean isDistinct) {
        this.functionName = functionName;
        this.isDistinct = isDistinct;
    }

    public PlugInProjectionExpression(String functionName, boolean isDistinct, Expression ... moreExpressions) {
        this.functionName = functionName;
        this.isDistinct = isDistinct;
        for (int i = 0; i < moreExpressions.length; ++i) {
            this.getChildren().add(moreExpressions[i]);
        }
    }

    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.functionName);
        writer.write(40);
        if (this.isDistinct) {
            writer.write("distinct ");
        }
        String delimiter = "";
        for (Expression expr : this.getChildren()) {
            writer.write(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.write(")");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }
}

