/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class StaticMethodExpression
extends ExpressionBase {
    private String className;
    private String method;
    private static final long serialVersionUID = -8876482797010708113L;

    public StaticMethodExpression() {
    }

    public StaticMethodExpression(String className, String method, Object[] parameters) {
        this.className = className;
        this.method = method;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                this.getChildren().add((Expression)parameters[i]);
                continue;
            }
            this.getChildren().add(new ConstantExpression(parameters[i]));
        }
    }

    public StaticMethodExpression(String className, String method) {
        this.className = className;
        this.method = method;
    }

    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.className);
        writer.write(46);
        writer.write(this.method);
        writer.write(40);
        String delimiter = "";
        for (Expression child : this.getChildren()) {
            writer.write(delimiter);
            child.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.write(41);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

