/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class TimePeriodExpression
extends ExpressionBase {
    private boolean hasDays;
    private boolean hasHours;
    private boolean hasMinutes;
    private boolean hasSeconds;
    private boolean hasMilliseconds;
    private static final long serialVersionUID = 1386645838943804276L;

    public TimePeriodExpression() {
    }

    public TimePeriodExpression(boolean hasDays, boolean hasHours, boolean hasMinutes, boolean hasSeconds, boolean hasMilliseconds) {
        this.hasDays = hasDays;
        this.hasHours = hasHours;
        this.hasMinutes = hasMinutes;
        this.hasSeconds = hasSeconds;
        this.hasMilliseconds = hasMilliseconds;
    }

    public TimePeriodExpression(Expression daysExpr, Expression hoursExpr, Expression minutesExpr, Expression secondsExpr, Expression millisecondsExpr) {
        if (daysExpr != null) {
            this.hasDays = true;
            this.addChild(daysExpr);
        }
        if (hoursExpr != null) {
            this.hasHours = true;
            this.addChild(hoursExpr);
        }
        if (minutesExpr != null) {
            this.hasMinutes = true;
            this.addChild(minutesExpr);
        }
        if (secondsExpr != null) {
            this.hasSeconds = true;
            this.addChild(secondsExpr);
        }
        if (millisecondsExpr != null) {
            this.hasMilliseconds = true;
            this.addChild(millisecondsExpr);
        }
    }

    public boolean isHasDays() {
        return this.hasDays;
    }

    public void setHasDays(boolean hasDays) {
        this.hasDays = hasDays;
    }

    public boolean isHasHours() {
        return this.hasHours;
    }

    public void setHasHours(boolean hasHours) {
        this.hasHours = hasHours;
    }

    public boolean isHasMinutes() {
        return this.hasMinutes;
    }

    public void setHasMinutes(boolean hasMinutes) {
        this.hasMinutes = hasMinutes;
    }

    public boolean isHasSeconds() {
        return this.hasSeconds;
    }

    public void setHasSeconds(boolean hasSeconds) {
        this.hasSeconds = hasSeconds;
    }

    public boolean isHasMilliseconds() {
        return this.hasMilliseconds;
    }

    public void setHasMilliseconds(boolean hasMilliseconds) {
        this.hasMilliseconds = hasMilliseconds;
    }

    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        int countExpr = 0;
        if (this.hasDays) {
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" days");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasHours) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" hours");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMinutes) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" minutes");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasSeconds) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" seconds");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMilliseconds) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" milliseconds");
        }
    }
}

