/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.TimeWindowIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeWindow
implements Iterable {
    private final ArrayDequeJDK6Backport<Pair<Long, ArrayDequeJDK6Backport<EventBean>>> window = new ArrayDequeJDK6Backport();
    private Long oldestTimestamp = null;
    private Map<EventBean, ArrayDequeJDK6Backport<EventBean>> reverseIndex;

    public TimeWindow(boolean isSupportRemoveStream) {
        if (isSupportRemoveStream) {
            this.reverseIndex = new HashMap<EventBean, ArrayDequeJDK6Backport<EventBean>>();
        }
    }

    public void adjust(long delta) {
        for (Pair<Long, ArrayDequeJDK6Backport<EventBean>> data : this.window) {
            data.setFirst(data.getFirst() + delta);
        }
        if (this.oldestTimestamp != null) {
            this.oldestTimestamp = this.oldestTimestamp + delta;
        }
    }

    public final void add(long timestamp2, EventBean bean) {
        if (this.oldestTimestamp == null) {
            this.oldestTimestamp = timestamp2;
        }
        if (this.window.isEmpty()) {
            ArrayDequeJDK6Backport<EventBean> listOfBeans = new ArrayDequeJDK6Backport<EventBean>();
            listOfBeans.add(bean);
            Pair pair = new Pair(timestamp2, listOfBeans);
            this.window.add(pair);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, listOfBeans);
            }
            return;
        }
        Pair<Long, ArrayDequeJDK6Backport<EventBean>> lastPair = this.window.getLast();
        if (lastPair.getFirst() == timestamp2) {
            lastPair.getSecond().add(bean);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, lastPair.getSecond());
            }
            return;
        }
        ArrayDequeJDK6Backport<EventBean> listOfBeans = new ArrayDequeJDK6Backport<EventBean>();
        listOfBeans.add(bean);
        Pair pair = new Pair(timestamp2, listOfBeans);
        if (this.reverseIndex != null) {
            this.reverseIndex.put(bean, listOfBeans);
        }
        this.window.add(pair);
    }

    public final void remove(EventBean event) {
        if (this.reverseIndex == null) {
            throw new UnsupportedOperationException("Time window does not accept event removal");
        }
        ArrayDequeJDK6Backport<EventBean> list = this.reverseIndex.get(event);
        if (list != null) {
            list.remove(event);
        }
        this.reverseIndex.remove(event);
    }

    public final ArrayDequeJDK6Backport<EventBean> expireEvents(long expireBefore) {
        if (this.window.isEmpty()) {
            return null;
        }
        Pair<Long, ArrayDequeJDK6Backport<EventBean>> pair = this.window.getFirst();
        if (pair.getFirst() >= expireBefore) {
            return null;
        }
        ArrayDequeJDK6Backport<EventBean> resultBeans = new ArrayDequeJDK6Backport<EventBean>();
        do {
            resultBeans.addAll((Collection)pair.getSecond());
            this.window.removeFirst();
        } while (!this.window.isEmpty() && (pair = this.window.getFirst()).getFirst() < expireBefore);
        this.oldestTimestamp = this.window.isEmpty() ? null : pair.getFirst();
        if (this.reverseIndex != null) {
            for (EventBean expired : resultBeans) {
                this.reverseIndex.remove(expired);
            }
        }
        return resultBeans;
    }

    public final Iterator<EventBean> iterator() {
        return new TimeWindowIterator(this.window);
    }

    public final Long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public final boolean isEmpty() {
        return this.window.isEmpty();
    }

    protected Map<EventBean, ArrayDequeJDK6Backport<EventBean>> getReverseIndex() {
        return this.reverseIndex;
    }
}

