/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationPlugInAggregationFunction;
import com.espertech.esper.client.ConfigurationPlugInEventRepresentation;
import com.espertech.esper.client.ConfigurationPlugInEventType;
import com.espertech.esper.client.ConfigurationVariable;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPServicesContextFactory;
import com.espertech.esper.core.EngineEnvContext;
import com.espertech.esper.core.InternalEventRouterImpl;
import com.espertech.esper.core.StatementContextFactoryDefault;
import com.espertech.esper.core.StatementEventTypeRefImpl;
import com.espertech.esper.core.StatementIsolationServiceImpl;
import com.espertech.esper.core.StatementLifecycleSvcImpl;
import com.espertech.esper.core.StatementLockFactoryImpl;
import com.espertech.esper.core.StatementVariableRefImpl;
import com.espertech.esper.core.deploy.DeploymentStateServiceImpl;
import com.espertech.esper.core.thread.ThreadingServiceImpl;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportServiceImpl;
import com.espertech.esper.epl.core.EngineSettingsService;
import com.espertech.esper.epl.db.DatabaseConfigService;
import com.espertech.esper.epl.db.DatabaseConfigServiceImpl;
import com.espertech.esper.epl.metric.MetricReportingServiceImpl;
import com.espertech.esper.epl.named.NamedWindowServiceImpl;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceImpl;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.epl.view.OutputConditionFactoryDefault;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventAdapterServiceImpl;
import com.espertech.esper.event.vaevent.ValueAddEventServiceImpl;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.XSDSchemaMapper;
import com.espertech.esper.filter.FilterServiceProvider;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.plugin.PlugInEventRepresentation;
import com.espertech.esper.plugin.PlugInEventRepresentationContext;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingMgmtService;
import com.espertech.esper.schedule.SchedulingMgmtServiceImpl;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.SchedulingServiceProvider;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.timer.TimeSourceServiceImpl;
import com.espertech.esper.timer.TimerServiceImpl;
import com.espertech.esper.util.GraphCircularDependencyException;
import com.espertech.esper.util.GraphUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.view.stream.StreamFactoryService;
import com.espertech.esper.view.stream.StreamFactoryServiceProvider;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPServicesContextFactoryDefault
implements EPServicesContextFactory {
    @Override
    public EPServicesContext createServicesContext(EPServiceProvider epServiceProvider, ConfigurationInformation configSnapshot) {
        EventAdapterServiceImpl eventAdapterService = new EventAdapterServiceImpl();
        EPServicesContextFactoryDefault.init(eventAdapterService, configSnapshot);
        ManagedReadWriteLock eventProcessingRWLock = new ManagedReadWriteLock("EventProcLock", false);
        TimeSourceService timeSourceService = EPServicesContextFactoryDefault.makeTimeSource(configSnapshot);
        SchedulingServiceSPI schedulingService = SchedulingServiceProvider.newService(timeSourceService);
        SchedulingMgmtServiceImpl schedulingMgmtService = new SchedulingMgmtServiceImpl();
        EngineImportService engineImportService = EPServicesContextFactoryDefault.makeEngineImportService(configSnapshot);
        EngineSettingsService engineSettingsService = new EngineSettingsService(configSnapshot.getEngineDefaults(), configSnapshot.getPlugInEventTypeResolutionURIs());
        DatabaseConfigService databaseConfigService = EPServicesContextFactoryDefault.makeDatabaseRefService(configSnapshot, schedulingService, schedulingMgmtService);
        PluggableObjectCollection plugInViews = new PluggableObjectCollection();
        plugInViews.addViews(configSnapshot.getPlugInViews());
        PluggableObjectCollection plugInPatternObj = new PluggableObjectCollection();
        plugInPatternObj.addPatternObjects(configSnapshot.getPlugInPatternObjects());
        EngineEnvContext jndiContext = new EngineEnvContext();
        StatementContextFactoryDefault statementContextFactory = new StatementContextFactoryDefault(plugInViews, plugInPatternObj);
        OutputConditionFactoryDefault outputConditionFactory = new OutputConditionFactoryDefault();
        long msecTimerResolution = configSnapshot.getEngineDefaults().getThreading().getInternalTimerMsecResolution();
        if (msecTimerResolution <= 0L) {
            throw new ConfigurationException("Timer resolution configuration not set to a valid value, expecting a non-zero value");
        }
        TimerServiceImpl timerService = new TimerServiceImpl(epServiceProvider.getURI(), msecTimerResolution);
        VariableServiceImpl variableService = new VariableServiceImpl(configSnapshot.getEngineDefaults().getVariables().getMsecVersionRelease(), schedulingService, eventAdapterService, null);
        EPServicesContextFactoryDefault.initVariables(variableService, configSnapshot.getVariables());
        StatementLockFactoryImpl statementLockFactory = new StatementLockFactoryImpl();
        StreamFactoryService streamFactoryService = StreamFactoryServiceProvider.newService(configSnapshot.getEngineDefaults().getViewResources().isShareViews());
        FilterServiceSPI filterService = FilterServiceProvider.newService();
        NamedWindowServiceImpl namedWindowService = new NamedWindowServiceImpl(statementLockFactory, variableService, engineSettingsService.getEngineSettings().getExecution().isPrioritized());
        ValueAddEventServiceImpl valueAddEventService = new ValueAddEventServiceImpl();
        valueAddEventService.init(configSnapshot.getRevisionEventTypes(), configSnapshot.getVariantStreams(), eventAdapterService);
        MetricReportingServiceImpl metricsReporting = new MetricReportingServiceImpl(configSnapshot.getEngineDefaults().getMetricsReporting(), epServiceProvider.getURI());
        StatementEventTypeRefImpl statementEventTypeRef = new StatementEventTypeRefImpl();
        StatementVariableRefImpl statementVariableRef = new StatementVariableRefImpl(variableService);
        ThreadingServiceImpl threadingService = new ThreadingServiceImpl(configSnapshot.getEngineDefaults().getThreading());
        InternalEventRouterImpl internalEventRouterImpl = new InternalEventRouterImpl();
        StatementIsolationServiceImpl statementIsolationService = new StatementIsolationServiceImpl();
        DeploymentStateServiceImpl deploymentStateService = new DeploymentStateServiceImpl();
        EPServicesContext services = new EPServicesContext(epServiceProvider.getURI(), epServiceProvider.getURI(), schedulingService, eventAdapterService, engineImportService, engineSettingsService, databaseConfigService, plugInViews, statementLockFactory, eventProcessingRWLock, null, jndiContext, statementContextFactory, plugInPatternObj, outputConditionFactory, timerService, filterService, streamFactoryService, namedWindowService, variableService, timeSourceService, valueAddEventService, metricsReporting, statementEventTypeRef, statementVariableRef, configSnapshot, threadingService, internalEventRouterImpl, statementIsolationService, schedulingMgmtService, deploymentStateService);
        StatementLifecycleSvcImpl statementLifecycleSvc = new StatementLifecycleSvcImpl(epServiceProvider, services);
        services.setStatementLifecycleSvc(statementLifecycleSvc);
        statementLifecycleSvc.addObserver(metricsReporting);
        statementIsolationService.setEpServicesContext(services);
        return services;
    }

    protected static TimeSourceService makeTimeSource(ConfigurationInformation configSnapshot) {
        if (configSnapshot.getEngineDefaults().getTimeSource().getTimeSourceType() == ConfigurationEngineDefaults.TimeSourceType.NANO) {
            TimeSourceServiceImpl.IS_SYSTEM_CURRENT_TIME = false;
        }
        return new TimeSourceServiceImpl();
    }

    protected static void initVariables(VariableService variableService, Map<String, ConfigurationVariable> variables) {
        for (Map.Entry<String, ConfigurationVariable> entry : variables.entrySet()) {
            try {
                variableService.createNewVariable(entry.getKey(), entry.getValue().getType(), entry.getValue().getInitializationValue(), null);
            }
            catch (VariableExistsException e2) {
                throw new ConfigurationException("Error configuring variables: " + e2.getMessage(), e2);
            }
            catch (VariableTypeException e3) {
                throw new ConfigurationException("Error configuring variables: " + e3.getMessage(), e3);
            }
        }
    }

    protected static void init(EventAdapterService eventAdapterService, ConfigurationInformation configSnapshot) {
        Set<String> dependentMapOrder;
        HashMap<String, ConfigurationEventTypeLegacy> classLegacyInfo = new HashMap<String, ConfigurationEventTypeLegacy>();
        for (Map.Entry<String, String> entry : configSnapshot.getEventTypeNames().entrySet()) {
            String typeName = entry.getKey();
            String className = entry.getValue();
            ConfigurationEventTypeLegacy legacyDef = configSnapshot.getEventTypesLegacy().get(typeName);
            if (legacyDef == null) continue;
            classLegacyInfo.put(className, legacyDef);
        }
        eventAdapterService.setClassLegacyConfigs(classLegacyInfo);
        eventAdapterService.setDefaultPropertyResolutionStyle(configSnapshot.getEngineDefaults().getEventMeta().getClassPropertyResolutionStyle());
        eventAdapterService.setDefaultAccessorStyle(configSnapshot.getEngineDefaults().getEventMeta().getDefaultAccessorStyle());
        for (String javaPackage : configSnapshot.getEventTypeAutoNamePackages()) {
            eventAdapterService.addAutoNamePackage(javaPackage);
        }
        Map<String, String> javaClassNames = configSnapshot.getEventTypeNames();
        for (Map.Entry<String, String> entry : javaClassNames.entrySet()) {
            try {
                String typeName = entry.getKey();
                eventAdapterService.addBeanType(typeName, entry.getValue(), false);
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
        Map<String, ConfigurationEventTypeXMLDOM> xmlDOMNames = configSnapshot.getEventTypesXMLDOM();
        for (Map.Entry<String, ConfigurationEventTypeXMLDOM> entry : xmlDOMNames.entrySet()) {
            SchemaModel schemaModel = null;
            if (entry.getValue().getSchemaResource() != null) {
                try {
                    schemaModel = XSDSchemaMapper.loadAndMap(entry.getValue().getSchemaResource(), 2);
                }
                catch (Exception ex) {
                    throw new ConfigurationException(ex.getMessage(), ex);
                }
            }
            try {
                eventAdapterService.addXMLDOMType(entry.getKey(), entry.getValue(), schemaModel);
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
        try {
            dependentMapOrder = GraphUtil.getTopDownOrder(configSnapshot.getMapSuperTypes());
        }
        catch (GraphCircularDependencyException e2) {
            throw new ConfigurationException("Error configuring engine, dependency graph between map type names is circular: " + e2.getMessage(), e2);
        }
        Map<String, Properties> mapNames = configSnapshot.getEventTypesMapEvents();
        Map<String, Map<String, Object>> nestableMapNames = configSnapshot.getEventTypesNestableMapEvents();
        dependentMapOrder.addAll(mapNames.keySet());
        dependentMapOrder.addAll(nestableMapNames.keySet());
        try {
            for (String mapName : dependentMapOrder) {
                Map<String, Object> propertiesNestable;
                Set<String> superTypes = configSnapshot.getMapSuperTypes().get(mapName);
                Properties propertiesUnnested = mapNames.get(mapName);
                if (propertiesUnnested != null) {
                    Map<String, Object> propertyTypes = EPServicesContextFactoryDefault.createPropertyTypes(propertiesUnnested);
                    eventAdapterService.addNestableMapType(mapName, propertyTypes, superTypes, true, false, false);
                }
                if ((propertiesNestable = nestableMapNames.get(mapName)) == null) continue;
                eventAdapterService.addNestableMapType(mapName, propertiesNestable, superTypes, true, false, false);
            }
        }
        catch (EventAdapterException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        Map<URI, ConfigurationPlugInEventRepresentation> plugInReps = configSnapshot.getPlugInEventRepresentation();
        for (Map.Entry<URI, ConfigurationPlugInEventRepresentation> entry : plugInReps.entrySet()) {
            Object pluginEventRepObj;
            Class<?> eventRepClass;
            String className = entry.getValue().getEventRepresentationClassName();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                eventRepClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Failed to load plug-in event representation class '" + className + "'", ex);
            }
            try {
                pluginEventRepObj = eventRepClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("Failed to instantiate plug-in event representation class '" + className + "' via default constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Illegal access to instantiate plug-in event representation class '" + className + "' via default constructor", ex);
            }
            if (!(pluginEventRepObj instanceof PlugInEventRepresentation)) {
                throw new ConfigurationException("Plug-in event representation class '" + className + "' does not implement the required interface " + PlugInEventRepresentation.class.getName());
            }
            URI eventRepURI = entry.getKey();
            PlugInEventRepresentation pluginEventRep = (PlugInEventRepresentation)pluginEventRepObj;
            Serializable initializer = entry.getValue().getInitializer();
            PlugInEventRepresentationContext context = new PlugInEventRepresentationContext(eventAdapterService, eventRepURI, initializer);
            try {
                pluginEventRep.init(context);
                eventAdapterService.addEventRepresentation(eventRepURI, pluginEventRep);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Plug-in event representation class '" + className + "' and URI '" + eventRepURI + "' did not initialize correctly : " + t.getMessage(), t);
            }
        }
        Map<String, ConfigurationPlugInEventType> plugInNames = configSnapshot.getPlugInEventTypes();
        for (Map.Entry<String, ConfigurationPlugInEventType> entry : plugInNames.entrySet()) {
            String name = entry.getKey();
            ConfigurationPlugInEventType config = entry.getValue();
            eventAdapterService.addPlugInEventType(name, config.getEventRepresentationResolutionURIs(), config.getInitializer());
        }
    }

    protected static EngineImportService makeEngineImportService(ConfigurationInformation configSnapshot) {
        EngineImportServiceImpl engineImportService = new EngineImportServiceImpl(configSnapshot.getEngineDefaults().getExpression().isExtendedAggregation());
        engineImportService.addMethodRefs(configSnapshot.getMethodInvocationReferences());
        try {
            for (String importName : configSnapshot.getImports()) {
                engineImportService.addImport(importName);
            }
            for (ConfigurationPlugInAggregationFunction config : configSnapshot.getPlugInAggregationFunctions()) {
                engineImportService.addAggregation(config.getName(), config.getFunctionClassName());
            }
        }
        catch (EngineImportException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return engineImportService;
    }

    protected static DatabaseConfigService makeDatabaseRefService(ConfigurationInformation configSnapshot, SchedulingService schedulingService, SchedulingMgmtService schedulingMgmtService) {
        DatabaseConfigServiceImpl databaseConfigService;
        try {
            ScheduleBucket allStatementsBucket = schedulingMgmtService.allocateBucket();
            databaseConfigService = new DatabaseConfigServiceImpl(configSnapshot.getDatabaseReferences(), schedulingService, allStatementsBucket);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return databaseConfigService;
    }

    private static Map<String, Object> createPropertyTypes(Properties properties) {
        HashMap<String, Object> propertyTypes = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String property = (String)entry.getKey();
            String className = (String)entry.getValue();
            Class clazz = JavaClassHelper.getClassForSimpleName(className);
            if (clazz == null) {
                throw new ConfigurationException("The type '" + className + "' is not a recognized type");
            }
            propertyTypes.put(property, clazz);
        }
        return propertyTypes;
    }
}

