/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.timer.TimeSourceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InsertIntoLatchSpin {
    private static final Log log = LogFactory.getLog(InsertIntoLatchSpin.class);
    private InsertIntoLatchSpin earlier;
    private long msecTimeout;
    private EventBean payload;
    private TimeSourceService timeSourceService;
    private volatile boolean isCompleted;

    public InsertIntoLatchSpin(InsertIntoLatchSpin earlier, long msecTimeout, EventBean payload, TimeSourceService timeSourceService) {
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.payload = payload;
        this.timeSourceService = timeSourceService;
    }

    public InsertIntoLatchSpin(TimeSourceService timeSourceService) {
        this.isCompleted = true;
        this.earlier = null;
        this.msecTimeout = 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public EventBean await() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = this.timeSourceService.getTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = this.timeSourceService.getTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info("Spin wait timeout exceeded in insert-into dispatch at " + this.msecTimeout + "ms, consider disabling insert-into between-statement latching for better performance");
                break;
            }
        }
        return this.payload;
    }

    public void done() {
        this.isCompleted = true;
        this.earlier = null;
    }
}

