/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.InternalEventRouterEntry;
import com.espertech.esper.core.InternalRoutePreprocessView;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventBeanCopyMethod;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalEventRouterPreprocessor {
    private static final Log log = LogFactory.getLog(InternalEventRouterPreprocessor.class);
    private static final Comparator<InternalEventRouterEntry> comparator = new Comparator<InternalEventRouterEntry>(){

        @Override
        public int compare(InternalEventRouterEntry o1, InternalEventRouterEntry o2) {
            if (o1.getPriority() > o2.getPriority()) {
                return 1;
            }
            if (o1.getPriority() < o2.getPriority()) {
                return -1;
            }
            if (o1.isDrop()) {
                return -1;
            }
            if (o2.isDrop()) {
                return -1;
            }
            return 0;
        }
    };
    private final EventBeanCopyMethod copyMethod;
    private final InternalEventRouterEntry[] entries;
    private final boolean empty;

    public InternalEventRouterPreprocessor(EventBeanCopyMethod copyMethod, List<InternalEventRouterEntry> entries) {
        this.copyMethod = copyMethod;
        Collections.sort(entries, comparator);
        this.entries = entries.toArray(new InternalEventRouterEntry[entries.size()]);
        this.empty = this.entries.length == 0;
    }

    public EventBean process(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        InternalRoutePreprocessView view;
        if (this.empty) {
            return event;
        }
        EventBean oldEvent = event;
        boolean haveCloned = false;
        EventBean[] eventsPerStream = new EventBean[]{event};
        InternalEventRouterEntry lastEntry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Boolean result;
            InternalEventRouterEntry entry = this.entries[i];
            ExprNode whereClause = entry.getOptionalWhereClause();
            if (whereClause != null && ((result = (Boolean)whereClause.evaluate(eventsPerStream, true, exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            if (entry.isDrop()) {
                return null;
            }
            if (lastEntry != null) {
                InternalRoutePreprocessView view2 = lastEntry.getOutputView();
                if (view2.isIndicate()) {
                    EventBean copied = this.copyMethod.copy(event);
                    view2.indicate(copied, oldEvent);
                    oldEvent = copied;
                } else if (this.entries[i].getOutputView().isIndicate()) {
                    oldEvent = this.copyMethod.copy(event);
                }
            }
            if (!haveCloned) {
                EventBean copiedEvent = this.copyMethod.copy(event);
                if (copiedEvent == null) {
                    log.warn("Event of type " + event.getEventType().getName() + " could not be copied");
                    return null;
                }
                haveCloned = true;
                eventsPerStream[0] = copiedEvent;
                event = copiedEvent;
            }
            this.apply(event, eventsPerStream, entry, exprEvaluatorContext);
            lastEntry = entry;
        }
        if (lastEntry != null && (view = lastEntry.getOutputView()).isIndicate()) {
            view.indicate(event, oldEvent);
        }
        return event;
    }

    private void apply(EventBean event, EventBean[] eventsPerStream, InternalEventRouterEntry entry, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values = new Object[entry.getAssignments().length];
        for (int i = 0; i < entry.getAssignments().length; ++i) {
            Object value = entry.getAssignments()[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (value != null && entry.getWideners()[i] != null) {
                value = entry.getWideners()[i].widen(value);
            }
            values[i] = value;
        }
        entry.getWriter().write(values, event);
    }
}

