/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalRoutePreprocessView
extends ViewSupport {
    private static final Log log = LogFactory.getLog(InternalRoutePreprocessView.class);
    private final EventType eventType;
    private final Iterator<EventBean> noiter = new SingleEventIterator(null);
    private final StatementResultService statementResultService;

    public InternalRoutePreprocessView(EventType eventType, StatementResultService statementResultService) {
        this.eventType = eventType;
        this.statementResultService = statementResultService;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.noiter;
    }

    public boolean isIndicate() {
        return this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic();
    }

    public void indicate(EventBean newEvent, EventBean oldEvent) {
        try {
            if (this.statementResultService.isMakeNatural()) {
                NaturalEventBean natural = new NaturalEventBean(this.eventType, new Object[]{newEvent.getUnderlying()}, newEvent);
                NaturalEventBean naturalOld = new NaturalEventBean(this.eventType, new Object[]{oldEvent.getUnderlying()}, oldEvent);
                this.updateChildren(new NaturalEventBean[]{natural}, new NaturalEventBean[]{naturalOld});
            } else {
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error updating child view: " + ex.getMessage());
        }
    }
}

