/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPSubscriberException;
import com.espertech.esper.core.DeliveryConvertor;
import com.espertech.esper.core.DeliveryConvertorMap;
import com.espertech.esper.core.DeliveryConvertorNull;
import com.espertech.esper.core.DeliveryConvertorObjectArr;
import com.espertech.esper.core.ResultDeliveryStrategy;
import com.espertech.esper.core.ResultDeliveryStrategyImpl;
import com.espertech.esper.core.ResultDeliveryStrategyMap;
import com.espertech.esper.core.ResultDeliveryStrategyObjectArr;
import com.espertech.esper.core.ResultDeliveryStrategyTypeArr;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;

public class ResultDeliveryStrategyFactory {
    public static ResultDeliveryStrategy create(Object subscriber, Class[] selectClauseTypes, String[] selectClauseColumns) throws EPSubscriberException {
        Method subscriptionMethod = null;
        ArrayList<Method> updateMethods = new ArrayList<Method>();
        for (Method method : subscriber.getClass().getMethods()) {
            if (!method.getName().equals("update") || !Modifier.isPublic(method.getModifiers())) continue;
            updateMethods.add(method);
        }
        if (updateMethods.size() == 0) {
            String message = "Subscriber object does not provide a public method by name 'update'";
            throw new EPSubscriberException(message);
        }
        boolean isMapArrayDelivery = false;
        boolean isObjectArrayDelivery = false;
        boolean isSingleRowMap = false;
        boolean isSingleRowObjectArr = false;
        boolean isTypeArrayDelivery = false;
        for (Method method : updateMethods) {
            Class<?> componentType;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == selectClauseTypes.length) {
                boolean fitsParameters = true;
                for (int i = 0; i < parameters.length; ++i) {
                    Class boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i]);
                    Class boxedParameterType = JavaClassHelper.getBoxedType(parameters[i]);
                    if (boxedExpressionType == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType, boxedParameterType)) continue;
                    fitsParameters = false;
                    break;
                }
                if (fitsParameters) {
                    subscriptionMethod = method;
                    break;
                }
            }
            if (parameters.length == 1 && parameters[0] == Map.class) {
                isSingleRowMap = true;
                subscriptionMethod = method;
                break;
            }
            if (parameters.length == 1 && parameters[0] == Object[].class) {
                isSingleRowObjectArr = true;
                subscriptionMethod = method;
                break;
            }
            if (parameters.length == 2 && parameters[0] == Map[].class && parameters[1] == Map[].class) {
                subscriptionMethod = method;
                isMapArrayDelivery = true;
                break;
            }
            if (parameters.length == 2 && parameters[0] == Object[][].class && parameters[1] == Object[][].class) {
                subscriptionMethod = method;
                isObjectArrayDelivery = true;
                break;
            }
            if (parameters.length != 2 || !parameters[0].equals(parameters[1]) || !parameters[0].isArray() || selectClauseTypes.length != 1 || !JavaClassHelper.isAssignmentCompatible(selectClauseTypes[0], componentType = parameters[0].getComponentType())) continue;
            subscriptionMethod = method;
            isTypeArrayDelivery = true;
            break;
        }
        if (subscriptionMethod == null) {
            if (updateMethods.size() > 1) {
                String parametersDesc = JavaClassHelper.getParameterAsString(selectClauseTypes);
                String message = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDesc;
                throw new EPSubscriberException(message);
            }
            Class<?>[] parameters = ((Method)updateMethods.get(0)).getParameterTypes();
            String parametersDesc = JavaClassHelper.getParameterAsString(selectClauseTypes);
            if (parameters.length != selectClauseTypes.length) {
                String message = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDesc;
                throw new EPSubscriberException(message);
            }
            for (int i = 0; i < parameters.length; ++i) {
                Class boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i]);
                Class boxedParameterType = JavaClassHelper.getBoxedType(parameters[i]);
                if (boxedExpressionType == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType, boxedParameterType)) continue;
                String message = "Subscriber method named 'update' for parameter number " + (i + 1) + " is not assignable, " + "expecting type '" + JavaClassHelper.getParameterAsString(selectClauseTypes[i]) + "' but found type '" + JavaClassHelper.getParameterAsString(parameters[i]) + "'";
                throw new EPSubscriberException(message);
            }
        }
        if (isMapArrayDelivery) {
            return new ResultDeliveryStrategyMap(subscriber, subscriptionMethod, selectClauseColumns);
        }
        if (isObjectArrayDelivery) {
            return new ResultDeliveryStrategyObjectArr(subscriber, subscriptionMethod);
        }
        if (isTypeArrayDelivery) {
            return new ResultDeliveryStrategyTypeArr(subscriber, subscriptionMethod);
        }
        Method startMethod = null;
        Method endMethod = null;
        Method rStreamMethod = null;
        try {
            startMethod = subscriber.getClass().getMethod("updateStart", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e2) {
            // empty catch block
        }
        try {
            endMethod = subscriber.getClass().getMethod("updateEnd", new Class[0]);
        }
        catch (NoSuchMethodException e3) {
            // empty catch block
        }
        try {
            rStreamMethod = subscriber.getClass().getMethod("updateRStream", subscriptionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e4) {
            // empty catch block
        }
        DeliveryConvertor convertor = isSingleRowMap ? new DeliveryConvertorMap(selectClauseColumns) : (isSingleRowObjectArr ? new DeliveryConvertorObjectArr() : new DeliveryConvertorNull());
        return new ResultDeliveryStrategyImpl(subscriber, convertor, subscriptionMethod, startMethod, endMethod, rStreamMethod);
    }
}

