/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.ResultDeliveryStrategy;
import com.espertech.esper.core.ResultDeliveryStrategyImpl;
import com.espertech.esper.event.NaturalEventBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDeliveryStrategyMap
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyMap.class);
    private final Object subscriber;
    private final FastMethod fastMethod;
    private final String[] columnNames;

    public ResultDeliveryStrategyMap(Object subscriber, Method method, String[] columnNames) {
        this.subscriber = subscriber;
        FastClass fastClass = FastClass.create(Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.fastMethod = fastClass.getMethod(method);
        this.columnNames = columnNames;
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Map[] newData = this.convert(result.getFirst());
        Map[] oldData = this.convert(result.getSecond());
        Object[] params = new Object[]{newData, oldData};
        try {
            this.fastMethod.invoke(this.subscriber, params);
        }
        catch (InvocationTargetException e2) {
            ResultDeliveryStrategyImpl.handle(log, e2, params, this.subscriber, this.fastMethod);
        }
    }

    private Map[] convert(EventBean[] events) {
        if (events == null || events.length == 0) {
            return null;
        }
        Map[] result = new Map[events.length];
        int length = 0;
        for (int i = 0; i < result.length; ++i) {
            if (!(events[i] instanceof NaturalEventBean)) continue;
            NaturalEventBean natural = (NaturalEventBean)events[i];
            result[length] = this.convert(natural);
            ++length;
        }
        if (length == 0) {
            return null;
        }
        if (length != events.length) {
            Map[] reduced = new Map[length];
            System.arraycopy(result, 0, reduced, 0, length);
            result = reduced;
        }
        return result;
    }

    private Map convert(NaturalEventBean natural) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] columns = natural.getNatural();
        for (int i = 0; i < columns.length; ++i) {
            map.put(this.columnNames[i], columns[i]);
        }
        return map;
    }
}

