/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.annotation.Drop;
import com.espertech.esper.client.annotation.Priority;
import com.espertech.esper.core.EPIsolationUnitServices;
import com.espertech.esper.core.EPServicesContext;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementContextFactory;
import com.espertech.esper.core.StatementFilterVersion;
import com.espertech.esper.core.StatementResultServiceImpl;
import com.espertech.esper.epl.core.MethodResolutionServiceImpl;
import com.espertech.esper.epl.join.JoinSetComposerFactoryImpl;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.spec.CreateWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.pattern.PatternContextFactoryDefault;
import com.espertech.esper.pattern.PatternObjectHelper;
import com.espertech.esper.pattern.PatternObjectResolutionServiceImpl;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.view.StatementStopServiceImpl;
import com.espertech.esper.view.ViewEnumHelper;
import com.espertech.esper.view.ViewResolutionServiceImpl;
import java.lang.annotation.Annotation;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementContextFactoryDefault
implements StatementContextFactory {
    private PluggableObjectCollection viewClasses = new PluggableObjectCollection();
    private PluggableObjectCollection patternObjectClasses;

    public StatementContextFactoryDefault(PluggableObjectCollection viewPlugIns, PluggableObjectCollection plugInPatternObj) {
        this.viewClasses.addObjects(viewPlugIns);
        this.viewClasses.addObjects(ViewEnumHelper.getBuiltinViews());
        this.patternObjectClasses = new PluggableObjectCollection();
        this.patternObjectClasses.addObjects(plugInPatternObj);
        this.patternObjectClasses.addObjects(PatternObjectHelper.getBuiltinPatternObjects());
    }

    @Override
    public StatementContext makeContext(String statementId, String statementName, String expression, boolean hasVariables, EPServicesContext engineServices, Map<String, Object> optAdditionalContext, OnTriggerDesc optOnTriggerDesc, CreateWindowDesc optCreateWindowDesc, boolean isFireAndForget, Annotation[] annotations, EPIsolationUnitServices isolationUnitServices) {
        ManagedLock statementResourceLock;
        ScheduleBucket scheduleBucket = engineServices.getSchedulingMgmtService().allocateBucket();
        if (optOnTriggerDesc != null && optOnTriggerDesc instanceof OnTriggerWindowDesc) {
            String windowName = ((OnTriggerWindowDesc)optOnTriggerDesc).getWindowName();
            statementResourceLock = engineServices.getNamedWindowService().getNamedWindowLock(windowName);
            if (statementResourceLock == null) {
                throw new EPStatementException("Named window '" + windowName + "' has not been declared", expression);
            }
        } else if (optCreateWindowDesc != null) {
            statementResourceLock = engineServices.getNamedWindowService().getNamedWindowLock(optCreateWindowDesc.getWindowName());
            if (statementResourceLock == null) {
                statementResourceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression);
                engineServices.getNamedWindowService().addNamedWindowLock(optCreateWindowDesc.getWindowName(), statementResourceLock);
            }
        } else {
            statementResourceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression);
        }
        StatementMetricHandle stmtMetric = null;
        if (!isFireAndForget) {
            stmtMetric = engineServices.getMetricsReportingService().getStatementHandle(statementId, statementName);
        }
        StatementFilterVersion statementFilterVersion = new StatementFilterVersion();
        AnnotationAnalysisResult annotationData = AnnotationAnalysisResult.analyzeAnnotations(annotations);
        EPStatementHandle epStatementHandle = new EPStatementHandle(statementId, statementName, statementResourceLock, expression, hasVariables, stmtMetric, annotationData.getPriority(), annotationData.isPremptive(), statementFilterVersion);
        MethodResolutionServiceImpl methodResolutionService = new MethodResolutionServiceImpl(engineServices.getEngineImportService(), engineServices.getSchedulingService(), engineServices.getConfigSnapshot().getEngineDefaults().getExpression().isUdfCache());
        PatternContextFactoryDefault patternContextFactory = new PatternContextFactoryDefault();
        ViewResolutionServiceImpl viewResolutionService = new ViewResolutionServiceImpl(this.viewClasses);
        PatternObjectResolutionServiceImpl patternResolutionService = new PatternObjectResolutionServiceImpl(this.patternObjectClasses);
        SchedulingServiceSPI schedulingService = engineServices.getSchedulingService();
        FilterServiceSPI filterService = engineServices.getFilterService();
        if (isolationUnitServices != null) {
            filterService = isolationUnitServices.getFilterService();
            schedulingService = isolationUnitServices.getSchedulingService();
        }
        return new StatementContext(engineServices.getEngineURI(), engineServices.getEngineInstanceId(), statementId, statementName, expression, schedulingService, scheduleBucket, engineServices.getEventAdapterService(), epStatementHandle, viewResolutionService, patternResolutionService, null, new StatementStopServiceImpl(), methodResolutionService, patternContextFactory, filterService, new JoinSetComposerFactoryImpl(), engineServices.getOutputConditionFactory(), engineServices.getNamedWindowService(), engineServices.getVariableService(), new StatementResultServiceImpl(engineServices.getStatementLifecycleSvc(), engineServices.getMetricsReportingService(), engineServices.getThreadingService()), engineServices.getEngineSettingsService().getPlugInEventTypeResolutionURIs(), engineServices.getValueAddEventService(), engineServices.getConfigSnapshot(), engineServices.getInternalEventEngineRouteDest(), engineServices.getMetricsReportingService(), engineServices.getViewService(), statementFilterVersion);
    }

    public static class AnnotationAnalysisResult {
        private int priority;
        private boolean isPremptive;

        private AnnotationAnalysisResult(int priority, boolean premptive) {
            this.priority = priority;
            this.isPremptive = premptive;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isPremptive() {
            return this.isPremptive;
        }

        public static AnnotationAnalysisResult analyzeAnnotations(Annotation[] annotations) {
            boolean preemptive = false;
            int priority = 0;
            boolean hasPrioritySetting = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Priority) {
                    priority = ((Priority)annotation).value();
                    hasPrioritySetting = true;
                }
                if (!(annotation instanceof Drop)) continue;
                preemptive = true;
            }
            if (!hasPrioritySetting && preemptive) {
                priority = 1;
            }
            return new AnnotationAnalysisResult(priority, preemptive);
        }
    }
}

