/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.core.UpdateDispatchFutureWait;
import com.espertech.esper.core.UpdateDispatchViewBase;
import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDispatchViewBlockingWait
extends UpdateDispatchViewBase {
    private UpdateDispatchFutureWait currentFutureWait = new UpdateDispatchFutureWait();
    private long msecTimeout;
    private static Log log = LogFactory.getLog(UpdateDispatchViewBlockingWait.class);

    public UpdateDispatchViewBlockingWait(StatementResultService statementResultServiceImpl, DispatchService dispatchService, long msecTimeout) {
        super(statementResultServiceImpl, dispatchService);
        this.msecTimeout = msecTimeout;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.newResult(new UniformPair<EventBean[]>(newData, oldData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newResult(UniformPair<EventBean[]> results) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".update for view " + this, results);
        }
        this.statementResultServiceImpl.indicate(results);
        if (!((Boolean)this.isDispatchWaiting.get()).booleanValue()) {
            UpdateDispatchFutureWait nextFutureWait;
            UpdateDispatchViewBlockingWait updateDispatchViewBlockingWait = this;
            synchronized (updateDispatchViewBlockingWait) {
                nextFutureWait = new UpdateDispatchFutureWait(this, this.currentFutureWait, this.msecTimeout);
                this.currentFutureWait.setLater(nextFutureWait);
                this.currentFutureWait = nextFutureWait;
            }
            this.dispatchService.addExternal(nextFutureWait);
            this.isDispatchWaiting.set(true);
        }
    }
}

