/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.client.deploy.DeploymentInformation;
import com.espertech.esper.core.deploy.DeploymentStateService;
import com.espertech.esper.util.UuidGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DeploymentStateServiceImpl
implements DeploymentStateService {
    private final Map<String, DeploymentInformation> deployments = new ConcurrentHashMap<String, DeploymentInformation>();

    public String nextDeploymentId() {
        return UuidGenerator.generate();
    }

    public synchronized DeploymentInformation[] getAllDeployments() {
        Collection<DeploymentInformation> dep = this.deployments.values();
        return dep.toArray(new DeploymentInformation[dep.size()]);
    }

    public synchronized void addUpdateDeployment(DeploymentInformation descriptor) {
        this.deployments.put(descriptor.getDeploymentId(), descriptor);
    }

    public synchronized void remove(String deploymentId) {
        this.deployments.remove(deploymentId);
    }

    public synchronized String[] getDeployments() {
        Set<String> keys = this.deployments.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized DeploymentInformation getDeployment(String deploymentId) {
        if (deploymentId == null) {
            return null;
        }
        return this.deployments.get(deploymentId);
    }

    public synchronized void destroy() {
        this.deployments.clear();
    }
}

