/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.deploy.DeploymentActionException;
import com.espertech.esper.client.deploy.DeploymentInformation;
import com.espertech.esper.client.deploy.DeploymentInformationItem;
import com.espertech.esper.client.deploy.DeploymentItemException;
import com.espertech.esper.client.deploy.DeploymentNotFoundException;
import com.espertech.esper.client.deploy.DeploymentOptions;
import com.espertech.esper.client.deploy.DeploymentOrder;
import com.espertech.esper.client.deploy.DeploymentOrderException;
import com.espertech.esper.client.deploy.DeploymentOrderOptions;
import com.espertech.esper.client.deploy.DeploymentResult;
import com.espertech.esper.client.deploy.DeploymentState;
import com.espertech.esper.client.deploy.DeploymentStateException;
import com.espertech.esper.client.deploy.EPDeploymentAdmin;
import com.espertech.esper.client.deploy.Module;
import com.espertech.esper.client.deploy.ModuleItem;
import com.espertech.esper.client.deploy.ParseException;
import com.espertech.esper.client.deploy.UndeploymentResult;
import com.espertech.esper.core.EPAdministratorSPI;
import com.espertech.esper.core.StatementEventTypeRef;
import com.espertech.esper.core.StatementIsolationService;
import com.espertech.esper.core.deploy.DeploymentStateService;
import com.espertech.esper.core.deploy.EPLModuleParseItem;
import com.espertech.esper.core.deploy.EPLModuleUtil;
import com.espertech.esper.core.deploy.ParseNode;
import com.espertech.esper.core.deploy.ParseNodeComment;
import com.espertech.esper.core.deploy.ParseNodeExpression;
import com.espertech.esper.core.deploy.ParseNodeImport;
import com.espertech.esper.core.deploy.ParseNodeModule;
import com.espertech.esper.core.deploy.ParseNodeUses;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.DependencyGraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPDeploymentAdminImpl
implements EPDeploymentAdmin {
    public static final String newline = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(EPDeploymentAdminImpl.class);
    private final EPAdministratorSPI epService;
    private final DeploymentStateService deploymentStateService;
    private final StatementEventTypeRef statementEventTypeRef;
    private final EventAdapterService eventAdapterService;
    private final StatementIsolationService statementIsolationService;

    public EPDeploymentAdminImpl(EPAdministratorSPI epService, DeploymentStateService deploymentStateService, StatementEventTypeRef statementEventTypeRef, EventAdapterService eventAdapterService, StatementIsolationService statementIsolationService) {
        this.epService = epService;
        this.deploymentStateService = deploymentStateService;
        this.statementEventTypeRef = statementEventTypeRef;
        this.eventAdapterService = eventAdapterService;
        this.statementIsolationService = statementIsolationService;
    }

    @Override
    public Module read(InputStream stream, String uri) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading module from input stream");
        }
        return this.readInternal(stream, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module read(File file) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + file.getAbsolutePath() + "'");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Module module = this.readInternal(inputStream, file.getAbsolutePath());
            return module;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    log.debug("Error closing input stream", e2);
                }
            }
        }
    }

    @Override
    public Module read(URL url) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource from url: " + url.toString());
        }
        return this.readInternal(url.openStream(), url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module read(String resource) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + resource + "'");
        }
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = EPDeploymentAdminImpl.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new IOException("Failed to find resource '" + resource + "' in classpath");
        }
        try {
            Module module = this.readInternal(stream, resource);
            return module;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e2) {
                log.debug("Error closing input stream", e2);
            }
        }
    }

    @Override
    public synchronized DeploymentResult deploy(Module module, DeploymentOptions options) throws DeploymentActionException {
        String deploymentId = this.deploymentStateService.nextDeploymentId();
        return this.deployInternal(module, options, deploymentId, Calendar.getInstance());
    }

    private DeploymentResult deployInternal(Module module, DeploymentOptions options, String deploymentId, Calendar addedDate) throws DeploymentActionException {
        ArrayList<DeploymentItemException> exceptions;
        if (options == null) {
            options = new DeploymentOptions();
        }
        if (log.isDebugEnabled()) {
            log.debug("Deploying module " + module);
        }
        if (module.getImports() != null) {
            for (String imported : module.getImports()) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding import " + imported);
                }
                this.epService.getConfiguration().addImport(imported);
            }
        }
        if (options.isCompile()) {
            exceptions = new ArrayList<DeploymentItemException>();
            for (ModuleItem item : module.getItems()) {
                try {
                    this.epService.compileEPL(item.getExpression());
                }
                catch (EPException ex) {
                    exceptions.add(new DeploymentItemException(ex.getMessage(), item.getExpression(), ex, item.getLineNumber()));
                }
            }
            if (!exceptions.isEmpty()) {
                throw this.buildException("Compilation failed", module, exceptions);
            }
        }
        if (options.isCompileOnly()) {
            return null;
        }
        exceptions = new ArrayList();
        ArrayList<DeploymentInformationItem> statementNames = new ArrayList<DeploymentInformationItem>();
        ArrayList<EPStatement> statements = new ArrayList<EPStatement>();
        HashSet<String> eventTypesReferenced = new HashSet<String>();
        for (ModuleItem item : module.getItems()) {
            try {
                EPStatement stmt;
                if (options.getIsolatedServiceProvider() == null) {
                    stmt = this.epService.createEPL(item.getExpression());
                } else {
                    EPServiceProviderIsolated unit = this.statementIsolationService.getIsolationUnit(options.getIsolatedServiceProvider(), -1);
                    stmt = unit.getEPAdministrator().createEPL(item.getExpression(), null, null);
                }
                statementNames.add(new DeploymentInformationItem(stmt.getName(), stmt.getText()));
                statements.add(stmt);
                Set<String> types = this.statementEventTypeRef.getTypesForStatementName(stmt.getName());
                if (types == null) continue;
                eventTypesReferenced.addAll(types);
            }
            catch (EPException ex) {
                exceptions.add(new DeploymentItemException(ex.getMessage(), item.getExpression(), ex, item.getLineNumber()));
                if (!options.isFailFast()) continue;
                break;
            }
        }
        if (!exceptions.isEmpty()) {
            if (options.isRollbackOnFail()) {
                log.debug("Rolling back intermediate statements for deployment");
                for (EPStatement stmt : statements) {
                    try {
                        stmt.destroy();
                    }
                    catch (Exception ex) {
                        log.debug("Failed to destroy created statement during rollback: " + ex.getMessage(), ex);
                    }
                }
                this.undeployTypes(eventTypesReferenced);
            }
            String text = "Deployment failed";
            if (options.isValidateOnly()) {
                text = "Validation failed";
            }
            throw this.buildException(text, module, exceptions);
        }
        if (options.isValidateOnly()) {
            log.debug("Rolling back created statements for validate-only");
            for (EPStatement stmt : statements) {
                try {
                    stmt.destroy();
                }
                catch (Exception ex) {
                    log.debug("Failed to destroy created statement during rollback: " + ex.getMessage(), ex);
                }
            }
            this.undeployTypes(eventTypesReferenced);
            return null;
        }
        DeploymentInformationItem[] deploymentInfoArr = statementNames.toArray(new DeploymentInformationItem[statementNames.size()]);
        DeploymentInformation desc = new DeploymentInformation(deploymentId, module, addedDate, Calendar.getInstance(), deploymentInfoArr, DeploymentState.DEPLOYED);
        this.deploymentStateService.addUpdateDeployment(desc);
        if (log.isDebugEnabled()) {
            log.debug("Module " + module + " was successfully deployed.");
        }
        return new DeploymentResult(desc.getDeploymentId(), Collections.unmodifiableList(statements));
    }

    private DeploymentActionException buildException(String msg, Module module, List<DeploymentItemException> exceptions) {
        String message = msg;
        if (module.getName() != null) {
            message = message + " in module '" + module.getName() + "'";
        }
        if (module.getUri() != null) {
            message = message + " in module url '" + module.getUri() + "'";
        }
        if (exceptions.size() > 0) {
            message = message + " : " + exceptions.get(0).getMessage();
        }
        return new DeploymentActionException(message, exceptions);
    }

    @Override
    public Module parse(String eplModuleText) throws IOException, ParseException {
        return this.parseInternal(eplModuleText, null);
    }

    @Override
    public synchronized UndeploymentResult undeployRemove(String deploymentId) throws DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        UndeploymentResult result = info.getState() == DeploymentState.DEPLOYED ? this.undeployRemoveInternal(info) : new UndeploymentResult(deploymentId, Collections.<DeploymentInformationItem>emptyList());
        this.deploymentStateService.remove(deploymentId);
        return result;
    }

    @Override
    public synchronized UndeploymentResult undeploy(String deploymentId) throws DeploymentStateException, DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.UNDEPLOYED) {
            throw new DeploymentStateException("Deployment by id '" + deploymentId + "' is already in undeployed state");
        }
        UndeploymentResult result = this.undeployRemoveInternal(info);
        DeploymentInformation updated = new DeploymentInformation(deploymentId, info.getModule(), info.getAddedDate(), Calendar.getInstance(), new DeploymentInformationItem[0], DeploymentState.UNDEPLOYED);
        this.deploymentStateService.addUpdateDeployment(updated);
        return result;
    }

    private UndeploymentResult undeployRemoveInternal(DeploymentInformation info) {
        DeploymentInformationItem[] reverted = new DeploymentInformationItem[info.getItems().length];
        for (int i = 0; i < info.getItems().length; ++i) {
            reverted[i] = info.getItems()[info.getItems().length - 1 - i];
        }
        ArrayList<DeploymentInformationItem> revertedStatements = new ArrayList<DeploymentInformationItem>();
        HashSet<String> referencedTypes = new HashSet<String>();
        for (DeploymentInformationItem item : reverted) {
            EPStatement statement = this.epService.getStatement(item.getStatementName());
            if (statement == null) {
                log.debug("Deployment id '" + info.getDeploymentId() + "' statement name '" + item + "' not found");
                continue;
            }
            referencedTypes.addAll(this.statementEventTypeRef.getTypesForStatementName(statement.getName()));
            if (statement.isDestroyed()) continue;
            try {
                statement.destroy();
            }
            catch (RuntimeException ex) {
                log.warn("Unexpected exception destroying statement: " + ex.getMessage(), ex);
            }
            revertedStatements.add(item);
        }
        this.undeployTypes(referencedTypes);
        Collections.reverse(revertedStatements);
        return new UndeploymentResult(info.getDeploymentId(), revertedStatements);
    }

    @Override
    public synchronized String[] getDeployments() {
        return this.deploymentStateService.getDeployments();
    }

    @Override
    public synchronized DeploymentInformation getDeployment(String deploymentId) {
        return this.deploymentStateService.getDeployment(deploymentId);
    }

    @Override
    public synchronized DeploymentInformation[] getDeploymentInformation() {
        return this.deploymentStateService.getAllDeployments();
    }

    @Override
    public synchronized DeploymentOrder getDeploymentOrder(Collection<Module> modules, DeploymentOrderOptions options) throws DeploymentOrderException {
        Stack<Integer> circular;
        if (options == null) {
            options = new DeploymentOrderOptions();
        }
        String[] deployments = this.deploymentStateService.getDeployments();
        ArrayList<Module> proposedModules = new ArrayList<Module>();
        proposedModules.addAll(modules);
        HashSet<String> availableModuleNames = new HashSet<String>();
        for (Module proposedModule : proposedModules) {
            if (proposedModule.getName() == null) continue;
            availableModuleNames.add(proposedModule.getName());
        }
        HashMap<String, HashSet<String>> usesPerModuleName = new HashMap<String, HashSet<String>>();
        for (String deployment : deployments) {
            DeploymentInformation info = this.deploymentStateService.getDeployment(deployment);
            if (info == null || info.getModule().getName() == null || info.getModule().getUses() == null) continue;
            HashSet<String> usesSet = (HashSet<String>)usesPerModuleName.get(info.getModule().getName());
            if (usesSet == null) {
                usesSet = new HashSet<String>();
                usesPerModuleName.put(info.getModule().getName(), usesSet);
            }
            usesSet.addAll(info.getModule().getUses());
        }
        for (Module proposedModule : proposedModules) {
            if (options.isCheckUses() && proposedModule.getUses() != null) {
                for (String uses : proposedModule.getUses()) {
                    if (availableModuleNames.contains(uses) || this.isDeployed(uses)) continue;
                    String message = "Module-dependency not found";
                    if (proposedModule.getName() != null) {
                        message = message + " as declared by module '" + proposedModule.getName() + "'";
                    }
                    message = message + " for uses-declaration '" + uses + "'";
                    throw new DeploymentOrderException(message);
                }
            }
            if (proposedModule.getName() == null || proposedModule.getUses() == null) continue;
            HashSet<String> usesSet = (HashSet<String>)usesPerModuleName.get(proposedModule.getName());
            if (usesSet == null) {
                usesSet = new HashSet<String>();
                usesPerModuleName.put(proposedModule.getName(), usesSet);
            }
            usesSet.addAll(proposedModule.getUses());
        }
        HashMap<String, TreeSet<Integer>> proposedModuleNames = new HashMap<String, TreeSet<Integer>>();
        int count = 0;
        for (Module proposedModule : proposedModules) {
            TreeSet<Integer> moduleNumbers = (TreeSet<Integer>)proposedModuleNames.get(proposedModule.getName());
            if (moduleNumbers == null) {
                moduleNumbers = new TreeSet<Integer>();
                proposedModuleNames.put(proposedModule.getName(), moduleNumbers);
            }
            moduleNumbers.add(count);
            ++count;
        }
        DependencyGraph graph = new DependencyGraph(proposedModules.size());
        int fromModule = 0;
        for (Module proposedModule : proposedModules) {
            if (proposedModule.getUses() == null || proposedModule.getUses().isEmpty()) {
                ++fromModule;
                continue;
            }
            TreeSet<Integer> dependentModuleNumbers = new TreeSet<Integer>();
            for (String use : proposedModule.getUses()) {
                SortedSet moduleNumbers = (SortedSet)proposedModuleNames.get(use);
                if (moduleNumbers == null) continue;
                dependentModuleNumbers.addAll(moduleNumbers);
            }
            dependentModuleNumbers.remove(fromModule);
            graph.addDependency(fromModule, dependentModuleNumbers);
            ++fromModule;
        }
        if (options.isCheckCircularDependency() && (circular = graph.getFirstCircularDependency()) != null) {
            String message = "";
            String delimiter = "";
            Iterator<Object> i$ = circular.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                message = message + delimiter;
                message = message + "module '" + ((Module)proposedModules.get(i)).getName() + "'";
                delimiter = " uses (depends on) ";
            }
            throw new DeploymentOrderException("Circular dependency detected in module uses-relationships: " + message);
        }
        ArrayList<Module> reverseDeployList = new ArrayList<Module>();
        HashSet<Integer> ignoreList = new HashSet<Integer>();
        while (ignoreList.size() < proposedModules.size()) {
            TreeSet<Integer> rootNodes = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -1 * o1.compareTo(o2);
                }
            });
            rootNodes.addAll(graph.getRootNodes(ignoreList));
            if (rootNodes.isEmpty()) {
                for (int i = 0; i < proposedModules.size(); ++i) {
                    if (ignoreList.contains(i)) continue;
                    rootNodes.add(i);
                    break;
                }
            }
            for (Integer root : rootNodes) {
                ignoreList.add(root);
                reverseDeployList.add((Module)proposedModules.get(root));
            }
        }
        Collections.reverse(reverseDeployList);
        return new DeploymentOrder(reverseDeployList);
    }

    @Override
    public synchronized boolean isDeployed(String moduleName) {
        DeploymentInformation[] infos = this.deploymentStateService.getAllDeployments();
        if (infos == null) {
            return false;
        }
        for (DeploymentInformation info : infos) {
            if (info.getModule().getName() == null || !info.getModule().getName().equals(moduleName)) continue;
            return info.getState() == DeploymentState.DEPLOYED;
        }
        return false;
    }

    @Override
    public synchronized DeploymentResult readDeploy(InputStream stream, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException {
        Module module = this.readInternal(stream, moduleURI);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized DeploymentResult readDeploy(String resource, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException {
        Module module = this.read(resource);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized DeploymentResult parseDeploy(String buffer, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException {
        Module module = this.parseInternal(buffer, moduleURI);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized String add(Module module) {
        String deploymentId = this.deploymentStateService.nextDeploymentId();
        DeploymentInformation desc = new DeploymentInformation(deploymentId, module, Calendar.getInstance(), Calendar.getInstance(), new DeploymentInformationItem[0], DeploymentState.UNDEPLOYED);
        this.deploymentStateService.addUpdateDeployment(desc);
        return deploymentId;
    }

    @Override
    public synchronized DeploymentResult deploy(String deploymentId, DeploymentOptions options) throws DeploymentNotFoundException, DeploymentStateException, DeploymentOrderException, DeploymentActionException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.DEPLOYED) {
            throw new DeploymentStateException("Module by deployment id '" + deploymentId + "' is already in deployed state");
        }
        this.getDeploymentOrder(Collections.singletonList(info.getModule()), null);
        return this.deployInternal(info.getModule(), options, deploymentId, info.getAddedDate());
    }

    @Override
    public synchronized void remove(String deploymentId) throws DeploymentStateException, DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.DEPLOYED) {
            throw new DeploymentStateException("Deployment by id '" + deploymentId + "' is in deployed state, please undeploy first");
        }
        this.deploymentStateService.remove(deploymentId);
    }

    private DeploymentResult deployQuick(Module module, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException {
        module.setUri(moduleURI);
        module.setArchiveName(moduleArchive);
        module.setUserObject(userObject);
        this.getDeploymentOrder(Collections.singletonList(module), null);
        return this.deploy(module, null);
    }

    private Module readInternal(InputStream stream, String resourceName) throws IOException, ParseException {
        String strLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringWriter buffer = new StringWriter();
        while ((strLine = br.readLine()) != null) {
            buffer.append(strLine);
            buffer.append(newline);
        }
        stream.close();
        return this.parseInternal(buffer.toString(), resourceName);
    }

    private Module parseInternal(String buffer, String resourceName) throws IOException, ParseException {
        List<EPLModuleParseItem> semicolonSegments = EPLModuleUtil.parse(buffer.toString());
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        for (EPLModuleParseItem segment : semicolonSegments) {
            nodes.add(EPLModuleUtil.getModule(segment, resourceName));
        }
        String moduleName = null;
        int count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment) continue;
            if (node instanceof ParseNodeModule) {
                if (moduleName != null) {
                    throw new ParseException("Duplicate use of the 'module' keyword for resource '" + resourceName + "'");
                }
                if (count > 0) {
                    throw new ParseException("The 'module' keyword must be the first declaration in the module file for resource '" + resourceName + "'");
                }
                moduleName = ((ParseNodeModule)node).getModuleName();
            }
            ++count;
        }
        LinkedHashSet<String> uses = new LinkedHashSet<String>();
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        count = 0;
        for (ParseNode node : nodes) {
            if (node instanceof ParseNodeComment || node instanceof ParseNodeModule) continue;
            String message = "The 'uses' and 'import' keywords must be the first declaration in the module file or follow the 'module' declaration";
            if (node instanceof ParseNodeUses) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                uses.add(((ParseNodeUses)node).getUses());
                continue;
            }
            if (node instanceof ParseNodeImport) {
                if (count > 0) {
                    throw new ParseException(message);
                }
                imports.add(((ParseNodeImport)node).getImported());
                continue;
            }
            ++count;
        }
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        for (ParseNode node : nodes) {
            if (!(node instanceof ParseNodeComment) && !(node instanceof ParseNodeExpression)) continue;
            boolean isComments = node instanceof ParseNodeComment;
            items.add(new ModuleItem(node.getItem().getExpression(), isComments, node.getItem().getLineNum(), node.getItem().getStartChar(), node.getItem().getEndChar()));
        }
        return new Module(moduleName, resourceName, uses, imports, items, buffer);
    }

    private void undeployTypes(Set<String> referencedTypes) {
        for (String typeName : referencedTypes) {
            boolean typeInUse = this.statementEventTypeRef.isInUse(typeName);
            if (typeInUse) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Event type '" + typeName + "' is in use, not removing type");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Event type '" + typeName + "' is no longer in use, removing type");
            }
            this.eventAdapterService.removeType(typeName);
        }
    }
}

