/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.deploy.ParseException;
import com.espertech.esper.core.deploy.EPLModuleParseItem;
import com.espertech.esper.core.deploy.ParseNode;
import com.espertech.esper.core.deploy.ParseNodeComment;
import com.espertech.esper.core.deploy.ParseNodeExpression;
import com.espertech.esper.core.deploy.ParseNodeImport;
import com.espertech.esper.core.deploy.ParseNodeModule;
import com.espertech.esper.core.deploy.ParseNodeUses;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPLModuleUtil {
    private static Log log = LogFactory.getLog(EPLModuleUtil.class);

    public static ParseNode getModule(EPLModuleParseItem item, String resourceName) throws ParseException, IOException {
        NoCaseSensitiveStream input = new NoCaseSensitiveStream(new StringReader(item.getExpression()));
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        CommonTokenStream tokenStream = new CommonTokenStream(lex);
        List tokens2 = tokenStream.getTokens();
        boolean isMeta = false;
        boolean isModule = false;
        boolean isUses = false;
        boolean isExpression = false;
        for (int beginIndex = 0; beginIndex < tokens2.size(); ++beginIndex) {
            Token t = (Token)tokens2.get(beginIndex);
            if (t.getType() == 318 || t.getType() == 319 || t.getType() == 320) {
                continue;
            }
            String tokenText = t.getText().trim().toLowerCase();
            if (tokenText.equals("module")) {
                isModule = true;
                isMeta = true;
            } else if (tokenText.equals("uses")) {
                isUses = true;
                isMeta = true;
            } else if (tokenText.equals("import")) {
                isMeta = true;
            } else {
                isExpression = true;
                break;
            }
            ++beginIndex;
            ++beginIndex;
            break;
        }
        if (isExpression) {
            return new ParseNodeExpression(item);
        }
        if (!isMeta) {
            return new ParseNodeComment(item);
        }
        StringWriter buffer = new StringWriter();
        for (int i = beginIndex; i < tokens2.size(); ++i) {
            Token t = (Token)tokens2.get(i);
            if (t.getType() != 262 && t.getType() != 264 && t.getType() != 269) {
                throw EPLModuleUtil.getMessage(isModule, isUses, resourceName);
            }
            buffer.append(t.getText().trim());
        }
        String result = buffer.toString().trim();
        if (result.length() == 0) {
            throw EPLModuleUtil.getMessage(isModule, isUses, resourceName);
        }
        if (isModule) {
            return new ParseNodeModule(item, result);
        }
        if (isUses) {
            return new ParseNodeUses(item, result);
        }
        return new ParseNodeImport(item, result);
    }

    private static ParseException getMessage(boolean module, boolean uses, String resourceName) {
        String message = "Keyword '";
        message = module ? message + "module" : (uses ? message + "uses" : message + "import");
        message = message + "' must be followed by a name or package name (set of names separated by dots) for resource '" + resourceName + "'";
        return new ParseException(message);
    }

    public static List<EPLModuleParseItem> parse(String module) {
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(module));
        }
        catch (IOException ex) {
            log.error("Exception reading model expression: " + ex.getMessage(), ex);
            return null;
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        CommonTokenStream tokens2 = new CommonTokenStream(lex);
        ArrayList<EPLModuleParseItem> statements = new ArrayList<EPLModuleParseItem>();
        StringWriter current = new StringWriter();
        Integer lineNum = null;
        int charPosStart = 0;
        int charPos = 0;
        for (Object token : tokens2.getTokens()) {
            Token t = (Token)token;
            if (t.getType() == 316) {
                if (current.toString().trim().length() > 0) {
                    statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, charPosStart, charPos));
                    lineNum = null;
                }
                current = new StringWriter();
                continue;
            }
            if (lineNum == null && t.getType() != 318) {
                lineNum = t.getLine();
                charPosStart = charPos;
            }
            current.append(t.getText());
            charPos += t.getText().length();
        }
        if (current.toString().trim().length() > 0) {
            statements.add(new EPLModuleParseItem(current.toString().trim(), lineNum == null ? 0 : lineNum, 0, 0));
        }
        return statements;
    }
}

