/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dispatch;

import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.dispatch.Dispatchable;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchServiceImpl
implements DispatchService {
    private static final ThreadLocal<ArrayDequeJDK6Backport<Dispatchable>> threadDispatchQueue = new ThreadLocal<ArrayDequeJDK6Backport<Dispatchable>>(){

        @Override
        protected synchronized ArrayDequeJDK6Backport<Dispatchable> initialValue() {
            return new ArrayDequeJDK6Backport<Dispatchable>();
        }
    };
    private static final Log log = LogFactory.getLog(DispatchServiceImpl.class);

    @Override
    public void dispatch() {
        DispatchServiceImpl.dispatchFromQueue(threadDispatchQueue.get());
    }

    @Override
    public void addExternal(Dispatchable dispatchable) {
        ArrayDequeJDK6Backport<Dispatchable> dispatchQueue = threadDispatchQueue.get();
        DispatchServiceImpl.addToQueue(dispatchable, dispatchQueue);
    }

    private static void addToQueue(Dispatchable dispatchable, ArrayDequeJDK6Backport<Dispatchable> dispatchQueue) {
        dispatchQueue.add(dispatchable);
    }

    private static void dispatchFromQueue(ArrayDequeJDK6Backport<Dispatchable> dispatchQueue) {
        Dispatchable next;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug(".dispatchFromQueue Dispatch queue is " + dispatchQueue.size() + " elements");
        }
        while ((next = dispatchQueue.poll()) != null) {
            next.execute();
        }
    }
}

