/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.agg.AggregationServiceBase;
import com.espertech.esper.epl.agg.AggregationServiceGroupAllImpl;
import com.espertech.esper.epl.agg.AggregationServiceGroupByImpl;
import com.espertech.esper.epl.agg.AggregationServiceGroupByReclaimAged;
import com.espertech.esper.epl.agg.AggregationServiceGroupByRefcountedImpl;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognizeImpl;
import com.espertech.esper.epl.agg.AggregationServiceNull;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.view.StatementStopService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationServiceFactory {
    public static AggregationServiceMatchRecognize getServiceMatchRecognize(int numStreams, Map<Integer, List<ExprAggregateNode>> measureExprNodesPerStream, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) {
        HashMap<Integer, LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>>> equivalencyListPerStream = new HashMap<Integer, LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>>>();
        for (Map.Entry<Integer, List<ExprAggregateNode>> entry : measureExprNodesPerStream.entrySet()) {
            LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>> equivalencyList = new LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>>();
            equivalencyListPerStream.put(entry.getKey(), equivalencyList);
            for (ExprAggregateNode selectAggNode : entry.getValue()) {
                AggregationServiceFactory.addEquivalent(selectAggNode, equivalencyList);
            }
        }
        LinkedHashMap<Integer, AggregationMethod[]> aggregatorsPerStream = new LinkedHashMap<Integer, AggregationMethod[]>();
        HashMap<Integer, ExprEvaluator[]> evaluatorsPerStream = new HashMap<Integer, ExprEvaluator[]>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            int index = 0;
            int stream = (Integer)equivalencyPerStream.getKey();
            AggregationMethod[] aggregators = new AggregationMethod[((Map)equivalencyPerStream.getValue()).size()];
            aggregatorsPerStream.put(stream, aggregators);
            ExprEvaluator[] evaluators = new ExprEvaluator[((Map)equivalencyPerStream.getValue()).size()];
            evaluatorsPerStream.put(stream, evaluators);
            for (ExprAggregateNode aggregateNode : ((Map)equivalencyPerStream.getValue()).keySet()) {
                evaluators[index] = aggregateNode.getChildNodes().size() > 1 ? AggregationServiceFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext) : (!aggregateNode.getChildNodes().isEmpty() ? (ExprEvaluator)aggregateNode.getChildNodes().get(0) : new ExprEvaluator(){

                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }
                });
                aggregators[index] = aggregateNode.getPrototypeAggregator();
                ++index;
            }
        }
        AggregationServiceMatchRecognizeImpl service = new AggregationServiceMatchRecognizeImpl(numStreams, aggregatorsPerStream, evaluatorsPerStream);
        int column = 0;
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            for (ExprAggregateNode aggregateNode : ((Map)equivalencyPerStream.getValue()).keySet()) {
                aggregateNode.setAggregationResultFuture(service, column);
                List equivalentAggregators = (List)((Map)equivalencyPerStream.getValue()).get(aggregateNode);
                if (equivalentAggregators != null) {
                    for (ExprAggregateNode equivalentAggNode : equivalentAggregators) {
                        equivalentAggNode.setAggregationResultFuture(service, column);
                    }
                }
                ++column;
            }
        }
        return service;
    }

    public static AggregationService getService(List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, boolean hasGroupByClause, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext, Annotation[] annotations, VariableService variableService, StatementStopService statementStopService) throws ExprValidationException {
        AggregationServiceBase service;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            return new AggregationServiceNull();
        }
        LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>> equivalencyList = new LinkedHashMap<ExprAggregateNode, List<ExprAggregateNode>>();
        for (ExprAggregateNode selectAggNode : selectAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(selectAggNode, equivalencyList);
        }
        for (ExprAggregateNode havingAggNode : havingAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(havingAggNode, equivalencyList);
        }
        for (ExprAggregateNode orderByAggNode : orderByAggregateExprNodes) {
            AggregationServiceFactory.addEquivalent(orderByAggNode, equivalencyList);
        }
        AggregationMethod[] aggregators = new AggregationMethod[equivalencyList.size()];
        ExprEvaluator[] evaluators = new ExprEvaluator[equivalencyList.size()];
        int index = 0;
        for (ExprAggregateNode aggregateNode : equivalencyList.keySet()) {
            evaluators[index] = aggregateNode.getChildNodes().size() > 1 ? AggregationServiceFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext) : (!aggregateNode.getChildNodes().isEmpty() ? (ExprEvaluator)aggregateNode.getChildNodes().get(0) : new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    return null;
                }
            });
            aggregators[index] = aggregateNode.getPrototypeAggregator();
            ++index;
        }
        if (hasGroupByClause) {
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            service = hasNoReclaim ? new AggregationServiceGroupByImpl(evaluators, aggregators, methodResolutionService) : (reclaimGroupAged != null ? new AggregationServiceGroupByReclaimAged(evaluators, aggregators, methodResolutionService, reclaimGroupAged, reclaimGroupFrequency, variableService, statementStopService) : new AggregationServiceGroupByRefcountedImpl(evaluators, aggregators, methodResolutionService));
        } else {
            service = new AggregationServiceGroupAllImpl(evaluators, aggregators);
        }
        int column = 0;
        for (ExprAggregateNode aggregateNode : equivalencyList.keySet()) {
            aggregateNode.setAggregationResultFuture(service, column);
            List equivalentAggregators = (List)equivalencyList.get(aggregateNode);
            if (equivalentAggregators != null) {
                for (ExprAggregateNode equivalentAggNode : equivalentAggregators) {
                    equivalentAggNode.setAggregationResultFuture(service, column);
                }
            }
            ++column;
        }
        return service;
    }

    private static ExprEvaluator getMultiNodeEvaluator(List<ExprNode> childNodes, ExprEvaluatorContext exprEvaluatorContext) {
        int size = childNodes.size();
        final List<ExprNode> exprNodes = childNodes;
        final Object[] prototype = new Object[size];
        int count = 0;
        for (ExprNode node : exprNodes) {
            if (node.isConstantResult()) {
                prototype[count] = node.evaluate(null, true, exprEvaluatorContext);
            }
            ++count;
        }
        return new ExprEvaluator(){

            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                int count = 0;
                for (ExprNode node : exprNodes) {
                    prototype[count] = node.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    ++count;
                }
                return prototype;
            }
        };
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, Map<ExprAggregateNode, List<ExprAggregateNode>> equivalencyList) {
        boolean foundEquivalent = false;
        for (Map.Entry<ExprAggregateNode, List<ExprAggregateNode>> entry : equivalencyList.entrySet()) {
            ExprAggregateNode aggNode = entry.getKey();
            if (!ExprNodeUtility.deepEquals(aggNode, aggNodeToAdd)) continue;
            List<ExprAggregateNode> equivalentAggregators = entry.getValue();
            if (equivalentAggregators == null) {
                equivalentAggregators = new ArrayList<ExprAggregateNode>();
            }
            equivalentAggregators.add(aggNodeToAdd);
            equivalencyList.put(aggNode, equivalentAggregators);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.put(aggNodeToAdd, null);
        }
    }
}

