/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodRowAged;
import com.espertech.esper.epl.agg.AggregationServiceBase;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregationServiceGroupByReclaimAged
extends AggregationServiceBase {
    private static final Log log = LogFactory.getLog(AggregationServiceGroupByReclaimAged.class);
    private static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    private Map<MultiKeyUntyped, AggregationMethodRowAged> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;
    private List<MultiKeyUntyped> removedKeys;
    private final EvaluationFunction evaluationFunctionMaxAge;
    private final EvaluationFunction evaluationFunctionFrequency;
    private Long nextSweepTime = null;
    private volatile long currentMaxAge = 60000L;
    private volatile long currentReclaimFrequency = 60000L;

    public AggregationServiceGroupByReclaimAged(ExprEvaluator[] evaluators, AggregationMethod[] prototypes, MethodResolutionService methodResolutionService, Hint reclaimGroupAged, Hint reclaimGroupFrequency, VariableService variableService, StatementStopService statementStopService) throws ExprValidationException {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethodRowAged>();
        this.removedKeys = new ArrayList<MultiKeyUntyped>();
        String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
        if (hintValueMaxAge == null) {
            throw new ExprValidationException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
        }
        this.evaluationFunctionMaxAge = this.getEvaluationFunction(variableService, statementStopService, hintValueMaxAge);
        String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
        if (reclaimGroupFrequency == null || hintValueFrequency == null) {
            this.evaluationFunctionFrequency = this.evaluationFunctionMaxAge;
            this.currentReclaimFrequency = this.getReclaimFrequency(this.currentReclaimFrequency);
        } else {
            this.evaluationFunctionFrequency = this.getEvaluationFunction(variableService, statementStopService, hintValueFrequency);
        }
    }

    private EvaluationFunction getEvaluationFunction(final VariableService variableService, StatementStopService statementStopService, String hintValue) throws ExprValidationException {
        Double valueDouble;
        final VariableReader variableReader = variableService.getReader(hintValue);
        if (variableReader != null) {
            if (!JavaClassHelper.isNumeric(variableReader.getType())) {
                throw new ExprValidationException("Variable type of variable '" + variableReader.getVariableName() + "' is not numeric");
            }
            final VariableChangeCallback changeCallback = new VariableChangeCallback(){

                public void update(Object newValue, Object oldValue) {
                    AggregationServiceGroupByReclaimAged.this.nextSweepTime = null;
                }
            };
            variableService.registerCallback(variableReader.getVariableNumber(), changeCallback);
            statementStopService.addSubscriber(new StatementStopCallback(){

                public void statementStopped() {
                    variableService.unregisterCallback(variableReader.getVariableNumber(), changeCallback);
                }
            });
            return new EvaluationFunctionVariable(variableReader);
        }
        try {
            valueDouble = DoubleValue.parseString(hintValue);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to parse hint parameter value '" + hintValue + "' as a double-typed seconds value or variable name");
        }
        if (valueDouble <= 0.0) {
            throw new ExprValidationException("Hint parameter value '" + hintValue + "' is an invalid value, expecting a double-typed seconds value or variable name");
        }
        return new EvaluationFunctionConstant(valueDouble);
    }

    public void clearResults() {
        this.aggregatorsPerGroup.clear();
    }

    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row;
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            this.currentMaxAge = this.getMaxAge(this.currentMaxAge);
            this.currentReclaimFrequency = this.getReclaimFrequency(this.currentReclaimFrequency);
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug("Reclaiming groups older then " + this.currentMaxAge + " msec and every " + this.currentReclaimFrequency + "msec in frequency");
            }
            this.nextSweepTime = currentTime + this.currentReclaimFrequency;
            this.sweep(currentTime, this.currentMaxAge);
        }
        if (!this.removedKeys.isEmpty()) {
            for (MultiKeyUntyped removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
        if ((row = this.aggregatorsPerGroup.get(groupByKey)) == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(this.aggregators) + 1L, currentTime, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            row.increaseRefcount();
            row.setLastUpdateTime(currentTime);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
    }

    private void sweep(long currentTime, long currentMaxAge) {
        ArrayDequeJDK6Backport<MultiKeyUntyped> removed = new ArrayDequeJDK6Backport<MultiKeyUntyped>();
        for (Map.Entry<MultiKeyUntyped, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= currentMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (MultiKeyUntyped key : removed) {
            this.aggregatorsPerGroup.remove(key);
        }
    }

    private long getMaxAge(long currentMaxAge) {
        Double maxAge = this.evaluationFunctionMaxAge.getLongValue();
        if (maxAge == null || maxAge <= 0.0) {
            return currentMaxAge;
        }
        return Math.round(maxAge * 1000.0);
    }

    private long getReclaimFrequency(long currentReclaimFrequency) {
        Double frequency = this.evaluationFunctionFrequency.getLongValue();
        if (frequency == null || frequency <= 0.0) {
            return currentReclaimFrequency;
        }
        return Math.round(frequency * 1000.0);
    }

    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (row != null) {
            groupAggregators = row.getMethods();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(this.aggregators) + 1L, currentTime, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
        row.decreaseRefcount();
        row.setLastUpdateTime(currentTime);
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(groupByKey);
        }
    }

    public void setCurrentRow(MultiKeyUntyped groupByKey) {
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        this.currentAggregatorRow = row != null ? row.getMethods() : null;
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
        }
    }

    public Object getValue(int column) {
        return this.currentAggregatorRow[column].getValue();
    }

    private static class EvaluationFunctionVariable
    implements EvaluationFunction {
        private VariableReader variableReader;

        private EvaluationFunctionVariable(VariableReader variableReader) {
            this.variableReader = variableReader;
        }

        public Double getLongValue() {
            Object val = this.variableReader.getValue();
            if (val != null && val instanceof Number) {
                return ((Number)val).doubleValue();
            }
            log.warn("Variable '" + this.variableReader.getVariableName() + " returned a null value, using last valid value");
            return null;
        }
    }

    private static class EvaluationFunctionConstant
    implements EvaluationFunction {
        private final double longValue;

        private EvaluationFunctionConstant(double longValue) {
            this.longValue = longValue;
        }

        public Double getLongValue() {
            return this.longValue;
        }
    }

    private static interface EvaluationFunction {
        public Double getLongValue();
    }
}

