/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import java.math.BigDecimal;

public class BigDecimalSumAggregator
implements AggregationMethod {
    private BigDecimal sum = new BigDecimal(0.0);
    private long numDataPoints;

    public void clear() {
        this.sum = new BigDecimal(0.0);
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum = this.sum.add((BigDecimal)object);
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum = this.sum.subtract((BigDecimal)object);
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    public Class getValueType() {
        return BigDecimal.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(BigDecimal.class);
    }
}

