/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;

public class FloatSumAggregator
implements AggregationMethod {
    private float sum;
    private long numDataPoints;

    public void clear() {
        this.sum = 0.0f;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum += ((Float)object).floatValue();
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum -= ((Float)object).floatValue();
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return Float.valueOf(this.sum);
    }

    public Class getValueType() {
        return Float.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(Float.class);
    }
}

