/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.schedule.TimeProvider;

public class RateEverAggregator
implements AggregationMethod {
    private final long interval;
    private final ArrayDequeJDK6Backport<Long> points;
    private boolean hasLeave = false;
    private final TimeProvider timeProvider;

    public RateEverAggregator(long interval, TimeProvider timeProvider) {
        this.interval = interval;
        this.timeProvider = timeProvider;
        this.points = new ArrayDequeJDK6Backport();
    }

    public void clear() {
        this.points.clear();
    }

    public void enter(Object object) {
        long timestamp2 = this.timeProvider.getTime();
        this.points.add(timestamp2);
        this.removeFromHead(timestamp2);
    }

    public void leave(Object object) {
    }

    public Object getValue() {
        long newest = this.points.getLast();
        this.removeFromHead(newest);
        if (!this.hasLeave) {
            return null;
        }
        if (this.points.isEmpty()) {
            return 0.0;
        }
        return (double)this.points.size() * 1000.0 / (double)this.interval;
    }

    private void removeFromHead(long timestamp2) {
        block2: {
            if (this.points.size() <= 1) break block2;
            do {
                long first;
                long delta;
                if ((delta = timestamp2 - (first = this.points.getFirst().longValue())) < this.interval) {
                    if (delta != this.interval) break;
                    this.hasLeave = true;
                    break;
                }
                this.points.remove();
                this.hasLeave = true;
            } while (!this.points.isEmpty());
        }
    }

    public Class getValueType() {
        return Double.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeRateEverAggregator(this.interval);
    }
}

