/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.annotation;

import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.annotation.AnnotationAttribute;
import com.espertech.esper.epl.annotation.AnnotationException;
import com.espertech.esper.epl.annotation.EPLAnnotationInvocationHandler;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    private static final Log log = LogFactory.getLog(AnnotationUtil.class);

    public static Annotation[] compileAnnotations(List<AnnotationDesc> annotationSpec, EngineImportService engineImportService, String eplStatement) {
        Annotation[] annotations;
        try {
            annotations = AnnotationUtil.compileAnnotations(annotationSpec, engineImportService);
        }
        catch (AnnotationException e2) {
            throw new EPStatementException("Failed to process statement annotations: " + e2.getMessage(), eplStatement);
        }
        catch (RuntimeException ex) {
            String message = "Unexpected exception compiling annotations in statement, please consult the log file and report the exception: " + ex.getMessage();
            log.error(message, ex);
            throw new EPStatementException(message, eplStatement);
        }
        return annotations;
    }

    private static Annotation[] compileAnnotations(List<AnnotationDesc> desc, EngineImportService engineImportService) throws AnnotationException {
        Annotation[] annotations = new Annotation[desc.size()];
        for (int i = 0; i < desc.size(); ++i) {
            annotations[i] = AnnotationUtil.createProxy(desc.get(i), engineImportService);
            if (!(annotations[i] instanceof Hint)) continue;
            HintEnum.validate(annotations[i]);
        }
        return annotations;
    }

    private static Annotation createProxy(AnnotationDesc desc, EngineImportService engineImportService) throws AnnotationException {
        Class annotationClass;
        try {
            annotationClass = engineImportService.resolveClass(desc.getName());
        }
        catch (EngineImportException e2) {
            throw new AnnotationException("Failed to resolve @-annotation class: " + e2.getMessage());
        }
        List<AnnotationAttribute> annotationAttributeLists = AnnotationUtil.getAttributes(annotationClass);
        HashSet<String> allAttributes = new HashSet<String>();
        LinkedHashSet<String> requiredAttributes = new LinkedHashSet<String>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            allAttributes.add(annotationAttribute.getName());
            if (annotationAttribute.getDefaultValue() == null) continue;
            requiredAttributes.add(annotationAttribute.getName());
        }
        ArrayList<String> providedValues = new ArrayList<String>();
        for (Pair<String, Object> annotationValuePair : desc.getAttributes()) {
            providedValues.add(annotationValuePair.getFirst());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            String attributeName = annotationAttribute.getName();
            Pair<String, Object> pairFound = null;
            for (Pair<String, Object> annotationValuePair : desc.getAttributes()) {
                if (!annotationValuePair.getFirst().equals(attributeName)) continue;
                pairFound = annotationValuePair;
            }
            Object valueProvided = pairFound == null ? null : pairFound.getSecond();
            Object value = AnnotationUtil.getFinalValue(annotationClass, annotationAttribute, valueProvided, engineImportService);
            properties.put(attributeName, value);
            providedValues.remove(attributeName);
            requiredAttributes.remove(attributeName);
        }
        if (requiredAttributes.size() > 0) {
            ArrayList required = new ArrayList(requiredAttributes);
            Collections.sort(required);
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + (String)required.iterator().next() + "'");
        }
        if (providedValues.size() > 0) {
            ArrayList provided = new ArrayList(providedValues);
            Collections.sort(provided);
            if (allAttributes.contains(provided.get(0))) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' has duplicate attribute values for attribute '" + (String)provided.get(0) + "'");
            }
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' does not have an attribute '" + (String)provided.get(0) + "'");
        }
        EPLAnnotationInvocationHandler handler = new EPLAnnotationInvocationHandler(annotationClass, properties);
        return (Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
    }

    private static Object getFinalValue(Class annotationClass, AnnotationAttribute annotationAttribute, Object value, EngineImportService engineImportService) throws AnnotationException {
        if (value == null) {
            if (annotationAttribute.getDefaultValue() == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + annotationAttribute.getName() + "'");
            }
            return annotationAttribute.getDefaultValue();
        }
        if (!annotationAttribute.getType().isArray()) {
            if (!annotationAttribute.getType().isAnnotation()) {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(value.getClass(), annotationAttribute.getType());
                Object finalValue = caster.cast(value);
                if (finalValue == null) {
                    throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
                }
                return finalValue;
            }
            if (!(value instanceof AnnotationDesc)) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
            }
            return AnnotationUtil.createProxy((AnnotationDesc)value, engineImportService);
        }
        if (!value.getClass().isArray()) {
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
        }
        Object array = Array.newInstance(annotationAttribute.getType().getComponentType(), Array.getLength(value));
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object arrayValue = Array.get(value, i);
            if (arrayValue == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + "non-null value for array elements for attribute '" + annotationAttribute.getName() + "'");
            }
            SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(arrayValue.getClass(), annotationAttribute.getType().getComponentType());
            Object finalValue = caster.cast(arrayValue);
            if (finalValue == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getComponentType().getSimpleName() + "-typed value for array elements for attribute '" + annotationAttribute.getName() + "' but received " + "a " + arrayValue.getClass().getSimpleName() + "-typed value");
            }
            Array.set(array, i, finalValue);
        }
        return array;
    }

    private static List<AnnotationAttribute> getAttributes(Class annotationClass) {
        ArrayList<AnnotationAttribute> props = new ArrayList<AnnotationAttribute>();
        Method[] methods = annotationClass.getMethods();
        if (methods == null) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length > 0 || methods[i].getName().equals("class") || methods[i].getName().equals("getClass") || methods[i].getName().equals("toString") || methods[i].getName().equals("annotationType") || methods[i].getName().equals("hashCode")) continue;
            props.add(new AnnotationAttribute(methods[i].getName(), methods[i].getReturnType(), methods[i].getDefaultValue()));
        }
        Collections.sort(props, new Comparator<AnnotationAttribute>(){

            @Override
            public int compare(AnnotationAttribute o1, AnnotationAttribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return props;
    }
}

