/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.EngineNoSuchMethodException;
import com.espertech.esper.epl.expression.ExprLeavingAggNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNthAggNode;
import com.espertech.esper.epl.expression.ExprRateAggNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MethodResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineImportServiceImpl
implements EngineImportService {
    private static final Log log = LogFactory.getLog(EngineImportServiceImpl.class);
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> aggregationFunctions = new HashMap<String, String>();
    private final Map<String, ConfigurationMethodRef> methodInvocationRef = new HashMap<String, ConfigurationMethodRef>();
    private final boolean allowExtendedAggregationFunc;

    public EngineImportServiceImpl(boolean allowExtendedAggregationFunc) {
        this.allowExtendedAggregationFunc = allowExtendedAggregationFunc;
    }

    @Override
    public ConfigurationMethodRef getConfigurationMethodRef(String className) {
        return this.methodInvocationRef.get(className);
    }

    public void addMethodRefs(Map<String, ConfigurationMethodRef> configs) {
        this.methodInvocationRef.putAll(configs);
    }

    @Override
    public void addImport(String importName) throws EngineImportException {
        if (!EngineImportServiceImpl.isClassName(importName) && !EngineImportServiceImpl.isPackageName(importName)) {
            throw new EngineImportException("Invalid import name '" + importName + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding import " + importName);
        }
        this.imports.add(importName);
    }

    @Override
    public void addAggregation(String functionName, String aggregationClass) throws EngineImportException {
        String existing = this.aggregationFunctions.get(functionName);
        if (existing != null) {
            throw new EngineImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (!EngineImportServiceImpl.isFunctionName(functionName)) {
            throw new EngineImportException("Invalid aggregation function name '" + functionName + "'");
        }
        if (!EngineImportServiceImpl.isClassName(aggregationClass)) {
            throw new EngineImportException("Invalid class name for aggregation '" + aggregationClass + "'");
        }
        this.aggregationFunctions.put(functionName.toLowerCase(), aggregationClass);
    }

    @Override
    public AggregationSupport resolveAggregation(String name) throws EngineImportException, EngineImportUndefinedException {
        Object object;
        Class<?> clazz;
        String className = this.aggregationFunctions.get(name);
        if (className == null) {
            className = this.aggregationFunctions.get(name.toLowerCase());
        }
        if (className == null) {
            throw new EngineImportUndefinedException("Aggregation function named '" + name + "' is not defined");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load aggregation class by name '" + className + "'", ex);
        }
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e2) {
            throw new EngineImportException("Error instantiating aggregation class by name '" + className + "'", e2);
        }
        catch (IllegalAccessException e3) {
            throw new EngineImportException("Illegal access instatiating aggregation class by name '" + className + "'", e3);
        }
        if (!(object instanceof AggregationSupport)) {
            throw new EngineImportException("Aggregation class by name '" + className + "' does not subclass AggregationSupport");
        }
        return (AggregationSupport)object;
    }

    @Override
    public Method resolveMethod(String className, String methodName, Class[] paramTypes) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e2) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e2);
        }
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, false);
        }
        catch (EngineNoSuchMethodException e3) {
            throw this.convert(clazz, methodName, paramTypes, e3);
        }
    }

    @Override
    public Method resolveMethod(String className, String methodName) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e2) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e2);
        }
        Method[] methods = clazz.getMethods();
        Method methodByName = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            if (methodByName != null) {
                throw new EngineImportException("Ambiguous method name: method by name '" + methodName + "' is overloaded in class '" + className + "'");
            }
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            methodByName = method;
        }
        if (methodByName == null) {
            throw new EngineImportException("Could not find static method named '" + methodName + "' in class '" + className + "'");
        }
        return methodByName;
    }

    @Override
    public Class resolveClass(String className) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e2) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e2);
        }
        return clazz;
    }

    protected Class resolveClassInternal(String className) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e2) {
            if (log.isDebugEnabled()) {
                log.debug("Class not found for resolving from name as-is '" + className + "'");
            }
            for (String importName : this.imports) {
                boolean isClassName = EngineImportServiceImpl.isClassName(importName);
                if (isClassName) {
                    if (!importName.endsWith(className)) continue;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(importName, true, cl);
                }
                String prefixedClassName = EngineImportServiceImpl.getPackageName(importName) + '.' + className;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(prefixedClassName, true, cl);
                }
                catch (ClassNotFoundException e3) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Class not found for resolving from name '" + prefixedClassName + "'");
                }
            }
            for (String name : this.methodInvocationRef.keySet()) {
                if (!JavaClassHelper.isSimpleNameFullyQualfied(className, name)) continue;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(name, true, cl);
                }
                catch (ClassNotFoundException e1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Class not found for resolving from method invocation ref:" + name);
                }
            }
            throw new ClassNotFoundException("Unknown class " + className);
        }
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true);
        }
        catch (EngineNoSuchMethodException e2) {
            throw this.convert(clazz, methodName, paramTypes, e2);
        }
    }

    private EngineImportException convert(Class clazz, String methodName, Class[] paramTypes, EngineNoSuchMethodException e2) {
        String expected = JavaClassHelper.getParameterAsString(paramTypes);
        String message = paramTypes.length > 0 ? "Could not find static method named '" + methodName + "' in class '" + clazz.getName() + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : "Could not find static method named '" + methodName + "' in class '" + clazz.getName() + "' taking no parameters";
        if (e2.getNearestMissMethod() != null) {
            message = message + " (nearest match found was '" + e2.getNearestMissMethod().getName() + "' taking type(s) '" + JavaClassHelper.getParameterAsString(e2.getNearestMissMethod().getParameterTypes()) + "')";
        }
        return new EngineImportException(message, e2);
    }

    @Override
    public ExprNode resolveAggExtendedBuiltin(String name, boolean isDistinct) {
        if (!this.allowExtendedAggregationFunc) {
            return null;
        }
        if (name.toLowerCase().equals("rate")) {
            return new ExprRateAggNode(isDistinct);
        }
        if (name.toLowerCase().equals("nth")) {
            return new ExprNthAggNode(isDistinct);
        }
        if (name.toLowerCase().equals("leaving")) {
            return new ExprLeavingAggNode(isDistinct);
        }
        return null;
    }

    protected String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    private static boolean isFunctionName(String functionName) {
        String classNameRegEx = "\\w+";
        return functionName.matches(classNameRegEx);
    }

    private static boolean isClassName(String importName) {
        String classNameRegEx = "(\\w+\\.)*\\w+(\\$\\w+)?";
        return importName.matches(classNameRegEx);
    }

    private static boolean isPackageName(String importName) {
        String classNameRegEx = "(\\w+\\.)+\\*";
        return importName.matches(classNameRegEx);
    }

    private static String getPackageName(String importName) {
        return importName.substring(0, importName.length() - 2);
    }
}

