/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.event.EventAdapterService;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPollingExecStrategy
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(MethodPollingExecStrategy.class);
    private final EventAdapterService eventAdapterService;
    private final FastMethod method;
    private boolean isArray;
    private boolean useMapType;
    private EventType eventType;

    public MethodPollingExecStrategy(EventAdapterService eventAdapterService, FastMethod method, boolean useMapType, EventType eventType) {
        this.eventAdapterService = eventAdapterService;
        this.method = method;
        this.isArray = method.getReturnType().isArray();
        this.useMapType = useMapType;
        this.eventType = eventType;
    }

    @Override
    public void start() {
    }

    @Override
    public void done() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues) {
        AbstractList rowResult = null;
        try {
            Object invocationResult = this.method.invoke(null, lookupValues);
            if (invocationResult != null) {
                if (this.isArray) {
                    int length = Array.getLength(invocationResult);
                    if (length > 0) {
                        rowResult = new ArrayList();
                        for (int i = 0; i < length; ++i) {
                            EventBean event;
                            Object value = Array.get(invocationResult, i);
                            if (value == null) {
                                log.warn("Expected non-null return result from method '" + this.method.getName() + "', but received null value");
                                continue;
                            }
                            if (this.useMapType) {
                                if (!(value instanceof Map)) {
                                    log.warn("Expected Map-type return result from method '" + this.method.getName() + "', but received type '" + value.getClass() + "'");
                                    continue;
                                }
                                Map mapValues = (Map)value;
                                event = this.eventAdapterService.adaptorForTypedMap(mapValues, this.eventType);
                            } else {
                                event = this.eventAdapterService.adapterForBean(value);
                            }
                            rowResult.add(event);
                        }
                    }
                } else {
                    rowResult = new LinkedList();
                    if (this.useMapType) {
                        if (!(invocationResult instanceof Map)) {
                            log.warn("Expected Map-type return result from method '" + this.method.getName() + "', but received type '" + invocationResult.getClass() + "'");
                        } else {
                            Map mapValues = (Map)invocationResult;
                            EventBean event = this.eventAdapterService.adaptorForTypedMap(mapValues, this.eventType);
                            rowResult.add(event);
                        }
                    } else {
                        EventBean event = this.eventAdapterService.adapterForBean(invocationResult);
                        rowResult.add(event);
                    }
                }
            }
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Method '" + this.method.getName() + "' of class '" + this.method.getJavaMethod().getDeclaringClass().getName() + "' reported an exception: " + ex.getTargetException(), ex.getTargetException());
        }
        return rowResult;
    }
}

