/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.IterablesArrayIterator;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.View;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPollingViewable
implements HistoricalEventViewable {
    private final MethodStreamSpec methodStreamSpec;
    private final PollExecStrategy pollExecStrategy;
    private final List<ExprNode> inputParameters;
    private final DataCache dataCache;
    private final EventType eventType;
    private final ThreadLocal<DataCache> dataCacheThreadLocal = new ThreadLocal();
    private final ExprEvaluatorContext exprEvaluatorContext;
    private SortedSet<Integer> requiredStreams;
    private ExprNode[] validatedExprNodes;
    private static final EventBean[][] NULL_ROWS = new EventBean[1][];
    private static final PollResultIndexingStrategy iteratorIndexingStrategy;

    public MethodPollingViewable(MethodStreamSpec methodStreamSpec, int myStreamNumber, List<ExprNode> inputParameters, PollExecStrategy pollExecStrategy, DataCache dataCache, EventType eventType, ExprEvaluatorContext exprEvaluatorContext) {
        this.methodStreamSpec = methodStreamSpec;
        this.inputParameters = inputParameters;
        this.pollExecStrategy = pollExecStrategy;
        this.dataCache = dataCache;
        this.eventType = eventType;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public void stop() {
        this.pollExecStrategy.destroy();
    }

    @Override
    public ThreadLocal<DataCache> getDataCacheThreadLocal() {
        return this.dataCacheThreadLocal;
    }

    @Override
    public void validate(EngineImportService engineImportService, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext, ConfigurationInformation configSnapshot, SchedulingService schedulingService, String engineURI, Map<Integer, List<ExprNode>> sqlParameters) throws ExprValidationException {
        Class[] paramTypes = new Class[this.inputParameters.size()];
        int count = 0;
        this.validatedExprNodes = new ExprNode[this.inputParameters.size()];
        this.requiredStreams = new TreeSet<Integer>();
        ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
        for (ExprNode exprNode : this.inputParameters) {
            ExprNode validated;
            this.validatedExprNodes[count] = validated = exprNode.getValidatedSubtree(streamTypeService, methodResolutionService, null, timeProvider, variableService, exprEvaluatorContext);
            paramTypes[count] = validated.getType();
            ++count;
            validated.accept(visitor);
        }
        for (Pair pair : visitor.getExprProperties()) {
            this.requiredStreams.add((Integer)pair.getFirst());
        }
        try {
            methodResolutionService.resolveMethod(this.methodStreamSpec.getClassName(), this.methodStreamSpec.getMethodName(), paramTypes);
        }
        catch (Exception e2) {
            if (this.inputParameters.size() == 0) {
                throw new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting no parameters in method: " + e2.getMessage());
            }
            throw new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting a method where parameters are typed '" + JavaClassHelper.getParameterAsString(paramTypes) + "': " + e2.getMessage());
        }
    }

    @Override
    public EventTable[] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy, ExprEvaluatorContext exprEvaluatorContext) {
        DataCache localDataCache = this.dataCacheThreadLocal.get();
        boolean strategyStarted = false;
        EventTable[] resultPerInputRow = new EventTable[lookupEventsPerStream.length];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            Object[] lookupValues = new Object[this.inputParameters.size()];
            for (int valueNum = 0; valueNum < this.inputParameters.size(); ++valueNum) {
                Object parameterValue;
                lookupValues[valueNum] = parameterValue = this.validatedExprNodes[valueNum].evaluate(lookupEventsPerStream[row], true, exprEvaluatorContext);
            }
            EventTable result = null;
            if (localDataCache != null) {
                result = localDataCache.getCached(lookupValues);
            }
            if (result == null && (result = this.dataCache.getCached(lookupValues)) != null && localDataCache != null) {
                localDataCache.put(lookupValues, result);
            }
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                EventTable indexTable;
                if (!strategyStarted) {
                    this.pollExecStrategy.start();
                    strategyStarted = true;
                }
                List<EventBean> pollResult = this.pollExecStrategy.poll(lookupValues);
                resultPerInputRow[row] = indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive());
                this.dataCache.put(lookupValues, indexTable);
                if (localDataCache == null) continue;
                localDataCache.put(lookupValues, indexTable);
                continue;
            }
            catch (EPException ex) {
                if (strategyStarted) {
                    this.pollExecStrategy.done();
                }
                throw ex;
            }
        }
        if (strategyStarted) {
            this.pollExecStrategy.done();
        }
        return resultPerInputRow;
    }

    @Override
    public View addView(View view) {
        view.setParent(this);
        return view;
    }

    @Override
    public List<View> getViews() {
        return Collections.emptyList();
    }

    @Override
    public boolean removeView(View view) {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public boolean hasViews() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        EventTable[] result = this.poll(NULL_ROWS, iteratorIndexingStrategy, this.exprEvaluatorContext);
        return new IterablesArrayIterator(result);
    }

    @Override
    public SortedSet<Integer> getRequiredStreams() {
        return this.requiredStreams;
    }

    @Override
    public boolean hasRequiredStreams() {
        return !this.requiredStreams.isEmpty();
    }

    static {
        MethodPollingViewable.NULL_ROWS[0] = new EventBean[1];
        iteratorIndexingStrategy = new PollResultIndexingStrategy(){

            @Override
            public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
                return new UnindexedEventTableList(pollResult);
            }
        };
    }
}

