/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.core.OrderByProcessorOrderedLimit;
import com.espertech.esper.epl.core.OrderByProcessorRowLimit;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.variable.VariableService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByProcessorFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorFactory.class);

    public static OrderByProcessor getProcessor(List<SelectClauseExprCompiledSpec> selectionList, List<ExprNode> groupByNodes, List<OrderByItem> orderByList, AggregationService aggregationService, RowLimitSpec rowLimitSpec, VariableService variableService, boolean isSortUsingCollator) throws ExprValidationException {
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        if (orderByList.isEmpty()) {
            log.debug(".getProcessor Using no OrderByProcessor");
            if (rowLimitSpec != null) {
                return new OrderByProcessorRowLimit(rowLimitSpec, variableService);
            }
            return null;
        }
        LinkedList<ExprAggregateNode> selectAggNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec element : selectionList) {
            ExprAggregateNode.getAggregatesBottomUp(element.getSelectExpression(), selectAggNodes);
        }
        LinkedList<ExprAggregateNode> orderAggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode orderByNode : orderByNodes) {
            ExprAggregateNode.getAggregatesBottomUp(orderByNode, orderAggNodes);
        }
        OrderByProcessorFactory.validateOrderByAggregates(selectAggNodes, orderAggNodes);
        boolean needsGroupByKeys = !selectionList.isEmpty() && !orderAggNodes.isEmpty();
        log.debug(".getProcessor Using OrderByProcessorImpl");
        OrderByProcessorImpl orderByProcessor = new OrderByProcessorImpl(orderByList, groupByNodes, needsGroupByKeys, aggregationService, isSortUsingCollator);
        if (rowLimitSpec == null) {
            return orderByProcessor;
        }
        return new OrderByProcessorOrderedLimit(orderByProcessor, new OrderByProcessorRowLimit(rowLimitSpec, variableService));
    }

    private static void validateOrderByAggregates(List<ExprAggregateNode> selectAggNodes, List<ExprAggregateNode> orderAggNodes) throws ExprValidationException {
        for (ExprAggregateNode orderAgg : orderAggNodes) {
            boolean inSelect = false;
            for (ExprAggregateNode selectAgg : selectAggNodes) {
                if (!ExprNodeUtility.deepEquals(selectAgg, orderAgg)) continue;
                inSelect = true;
                break;
            }
            if (inSelect) continue;
            throw new ExprValidationException("Aggregate functions in the order-by clause must also occur in the select expression");
        }
    }
}

