/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderByProcessorRowLimit
implements OrderByProcessor {
    private static final Log log = LogFactory.getLog(OrderByProcessorImpl.class);
    private final VariableReader numRowsVariableReader;
    private final VariableReader offsetVariableReader;
    private int currentRowLimit;
    private int currentOffset;

    public OrderByProcessorRowLimit(RowLimitSpec rowLimitSpec, VariableService variableService) throws ExprValidationException {
        if (rowLimitSpec.getNumRowsVariable() != null) {
            this.numRowsVariableReader = variableService.getReader(rowLimitSpec.getNumRowsVariable());
            if (this.numRowsVariableReader == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getNumRowsVariable() + "' has not been declared");
            }
            if (!JavaClassHelper.isNumeric(this.numRowsVariableReader.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.numRowsVariableReader = null;
            this.currentRowLimit = rowLimitSpec.getNumRows();
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (rowLimitSpec.getOptionalOffsetVariable() != null) {
            this.offsetVariableReader = variableService.getReader(rowLimitSpec.getOptionalOffsetVariable());
            if (this.offsetVariableReader == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getOptionalOffsetVariable() + "' has not been declared");
            }
            if (!JavaClassHelper.isNumeric(this.offsetVariableReader.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.offsetVariableReader = null;
            if (rowLimitSpec.getOptionalOffset() != null) {
                this.currentOffset = rowLimitSpec.getOptionalOffset();
                if (this.currentOffset <= 0) {
                    throw new ExprValidationException("Limit clause requires a positive offset");
                }
            } else {
                this.currentOffset = 0;
            }
        }
    }

    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.applyLimit(outgoingEvents);
    }

    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.applyLimit(outgoingEvents);
    }

    public MultiKeyUntyped getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    public MultiKeyUntyped[] getSortKeyPerRow(EventBean[] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    public EventBean[] sort(EventBean[] outgoingEvents, MultiKeyUntyped[] orderKeys, ExprEvaluatorContext exprEvaluatorContext) {
        return this.applyLimit(outgoingEvents);
    }

    protected EventBean[] applyLimit(EventBean[] outgoingEvents) {
        Number varValue;
        if (outgoingEvents == null) {
            return null;
        }
        if (this.numRowsVariableReader != null) {
            varValue = (Number)this.numRowsVariableReader.getValue();
            this.currentRowLimit = varValue != null ? varValue.intValue() : Integer.MAX_VALUE;
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (this.offsetVariableReader != null) {
            varValue = (Number)this.offsetVariableReader.getValue();
            this.currentOffset = varValue != null ? varValue.intValue() : 0;
            if (this.currentOffset < 0) {
                this.currentOffset = 0;
            }
        }
        if (this.currentOffset == 0) {
            if (outgoingEvents.length <= this.currentRowLimit) {
                return outgoingEvents;
            }
            if (this.currentRowLimit == 0) {
                return null;
            }
            EventBean[] limited = new EventBean[this.currentRowLimit];
            System.arraycopy(outgoingEvents, 0, limited, 0, this.currentRowLimit);
            return limited;
        }
        int maxInterested = this.currentRowLimit + this.currentOffset;
        if (this.currentRowLimit == Integer.MAX_VALUE) {
            maxInterested = Integer.MAX_VALUE;
        }
        if (outgoingEvents.length > maxInterested) {
            EventBean[] limited = new EventBean[this.currentRowLimit];
            System.arraycopy(outgoingEvents, this.currentOffset, limited, 0, this.currentRowLimit);
            return limited;
        }
        if (outgoingEvents.length <= this.currentOffset) {
            return null;
        }
        int size = outgoingEvents.length - this.currentOffset;
        EventBean[] limited = new EventBean[size];
        System.arraycopy(outgoingEvents, this.currentOffset, limited, 0, size);
        return limited;
    }
}

