/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetAggregateGroupedIterator;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorAggregateGrouped
implements ResultSetProcessor {
    private static final Log log = LogFactory.getLog(ResultSetProcessorAggregateGrouped.class);
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final List<ExprNode> groupKeyNodes;
    private final ExprNode optionalHavingNode;
    private final boolean isSorting;
    private final boolean isSelectRStream;
    private final boolean isUnidirectional;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final Map<MultiKeyUntyped, EventBean[]> eventGroupReps = new HashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> workCollection = new LinkedHashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> workCollectionTwo = new LinkedHashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> newGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> oldGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();

    public ResultSetProcessorAggregateGrouped(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, List<ExprNode> groupKeyNodes, ExprNode optionalHavingNode, boolean isSelectRStream, boolean isUnidirectional, ExprEvaluatorContext exprEvaluatorContext) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.groupKeyNodes = groupKeyNodes;
        this.optionalHavingNode = optionalHavingNode;
        this.isSorting = orderByProcessor != null;
        this.isSelectRStream = isSelectRStream;
        this.isUnidirectional = isUnidirectional;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        MultiKeyUntyped[] newDataGroupByKeys = this.generateGroupKeys(newEvents, true);
        MultiKeyUntyped[] oldDataGroupByKeys = this.generateGroupKeys(oldEvents, false);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processJoinResults creating old output events");
        }
        if (this.isUnidirectional) {
            this.clear();
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataGroupByKeys[count], this.exprEvaluatorContext);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataGroupByKeys[count], this.exprEvaluatorContext);
                ++count;
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = this.generateOutputEventsJoin(oldEvents, oldDataGroupByKeys, this.oldGenerators, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(newEvents, newDataGroupByKeys, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        MultiKeyUntyped[] newDataGroupByKeys = this.generateGroupKeys(newData, true);
        MultiKeyUntyped[] oldDataGroupByKeys = this.generateGroupKeys(oldData, false);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".processViewResults creating old output events");
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataGroupByKeys[i], this.exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataGroupByKeys[i], this.exprEvaluatorContext);
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = this.generateOutputEventsView(oldData, oldDataGroupByKeys, this.oldGenerators, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsView(newData, newDataGroupByKeys, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(EventBean[] outputEvents, MultiKeyUntyped[] groupByKeys, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        if (outputEvents == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[outputEvents.length];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[outputEvents.length];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[outputEvents.length][];
        }
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            eventsPerStream[0] = outputEvents[count];
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize);
            keys[count] = groupByKeys[count];
            if (this.isSorting) {
                EventBean[] currentEventsPerStream = new EventBean[]{outputEvents[count]};
                generators.put(keys[count], currentEventsPerStream);
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.exprEvaluatorContext);
        }
        return events;
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    protected MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        Object[] keys = new Object[this.groupKeyNodes.size()];
        int count = 0;
        for (ExprNode exprNode : this.groupKeyNodes) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    private EventBean[] generateOutputEventsJoin(Set<MultiKey<EventBean>> resultSet, MultiKeyUntyped[] groupByKeys, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        if (resultSet.isEmpty()) {
            return null;
        }
        EventBean[] events = new EventBean[resultSet.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[resultSet.size()][];
        }
        int count = 0;
        for (MultiKey<EventBean> row : resultSet) {
            Boolean result;
            EventBean[] eventsPerStream = row.getArray();
            if (this.isUnidirectional) {
                this.clear();
            }
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize);
            keys[count] = groupByKeys[count];
            if (this.isSorting) {
                generators.put(keys[count], eventsPerStream);
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.exprEvaluatorContext);
        }
        return events;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateGroupedIterator(parent.iterator(), this, this.aggregationService, this.exprEvaluatorContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        Iterator<EventBean> i$ = parent.iterator();
        while (i$.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = i$.next();
            MultiKeyUntyped groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.optionalHavingNode != null) {
                pass = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, true, this.exprEvaluatorContext);
            }
            if (pass == null || !pass.booleanValue()) continue;
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true));
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.exprEvaluatorContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.exprEvaluatorContext);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprNode getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        MultiKeyUntyped[] groupByKeys = this.generateGroupKeys(joinSet, true);
        EventBean[] result = this.generateOutputEventsJoin(joinSet, groupByKeys, this.newGenerators, true, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        void var9_38;
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            void var9_24;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
                Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (this.isUnidirectional) {
                    this.clear();
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (this.isSelectRStream) {
                    this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedJoin(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_20 = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray2 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    void var9_22;
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_22, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && var9_24 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_24);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            void var9_32;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            this.workCollection.clear();
            for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
                Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (this.isUnidirectional) {
                    this.clear();
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        MultiKeyUntyped mk = newDataMultiKey[count];
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.exprEvaluatorContext);
                        ++count;
                        this.workCollection.put(mk, aNewData.getArray());
                        this.eventGroupReps.put(mk, aNewData.getArray());
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (this.isSelectRStream) {
                    this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedJoin(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            for (Map.Entry entry : this.eventGroupReps.entrySet()) {
                if (this.workCollection.containsKey(entry.getKey())) continue;
                this.workCollectionTwo.put((MultiKeyUntyped)entry.getKey(), (EventBean[])entry.getValue());
                this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
                this.workCollectionTwo.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_28 = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray3 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    void var9_30;
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_30, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && var9_32 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_32);
        }
        LinkedHashMap<MultiKeyUntyped, EventBean> lastPerGroupNew = new LinkedHashMap<MultiKeyUntyped, EventBean>();
        LinkedHashMap<MultiKeyUntyped, EventBean> lastPerGroupOld = null;
        if (this.isSelectRStream) {
            lastPerGroupOld = new LinkedHashMap<MultiKeyUntyped, EventBean>();
        }
        LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped> newEventsSortKey = null;
        LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped>();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
            Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
            MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
            MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (this.isUnidirectional) {
                this.clear();
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    MultiKeyUntyped mk = newDataMultiKey[count];
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.exprEvaluatorContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.workCollection.put(oldDataMultiKey[count], anOldData.getArray());
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.exprEvaluatorContext);
                    ++count;
                }
            }
            if (this.isSelectRStream) {
                this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedJoin(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        Object var9_34 = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray4 = eventBeanArray = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                void var9_36;
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_36, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && var9_38 == null) {
            return null;
        }
        return new UniformPair<void>((void)newEventsArr, var9_38);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        void var10_39;
        EventBean[] eventsPerStream = new EventBean[1];
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            void var10_25;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                int i$;
                int len$;
                EventBean[] arr$;
                int count;
                EventBean[] newData = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    count = 0;
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    arr$ = oldData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (this.isSelectRStream) {
                    this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedView(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var10_21 = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray2 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    void var10_23;
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var10_23, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && var10_25 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var10_25);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            void var10_33;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            this.workCollection.clear();
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                int count;
                EventBean[] newData = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                eventsPerStream = new EventBean[1];
                if (newData != null) {
                    count = 0;
                    for (EventBean aNewData : newData) {
                        MultiKeyUntyped mk = newDataMultiKey[count];
                        eventsPerStream[0] = aNewData;
                        this.aggregationService.applyEnter(eventsPerStream, mk, this.exprEvaluatorContext);
                        ++count;
                        this.workCollection.put(mk, eventsPerStream);
                        this.eventGroupReps.put(mk, new EventBean[]{aNewData});
                    }
                }
                if (oldData != null) {
                    count = 0;
                    EventBean[] arr$ = oldData;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (this.isSelectRStream) {
                    this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedView(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            for (Map.Entry entry : this.eventGroupReps.entrySet()) {
                if (this.workCollection.containsKey(entry.getKey())) continue;
                this.workCollectionTwo.put((MultiKeyUntyped)entry.getKey(), (EventBean[])entry.getValue());
                this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
                this.workCollectionTwo.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var10_29 = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray3 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    void var10_31;
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var10_31, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && var10_33 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var10_33);
        }
        LinkedHashMap<MultiKeyUntyped, EventBean> lastPerGroupNew = new LinkedHashMap<MultiKeyUntyped, EventBean>();
        LinkedHashMap<MultiKeyUntyped, EventBean> lastPerGroupOld = null;
        if (this.isSelectRStream) {
            lastPerGroupOld = new LinkedHashMap<MultiKeyUntyped, EventBean>();
        }
        LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped> newEventsSortKey = null;
        LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped>();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedHashMap<MultiKeyUntyped, MultiKeyUntyped>();
            }
        }
        for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
            int count;
            EventBean[] newData = uniformPair.getFirst();
            EventBean[] oldData = uniformPair.getSecond();
            MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
            MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            eventsPerStream = new EventBean[1];
            if (newData != null) {
                count = 0;
                for (EventBean aNewData : newData) {
                    MultiKeyUntyped mk = newDataMultiKey[count];
                    eventsPerStream[0] = aNewData;
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.exprEvaluatorContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (EventBean anOldData : oldData) {
                    this.workCollection.put(oldDataMultiKey[count], eventsPerStream);
                    eventsPerStream[0] = anOldData;
                    this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.exprEvaluatorContext);
                    ++count;
                }
            }
            if (this.isSelectRStream) {
                this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedView(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        Object var10_35 = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray4 = eventBeanArray = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                void var10_37;
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var10_37, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && var10_39 == null) {
            return null;
        }
        return new UniformPair<void>((void)newEventsArr, var10_39);
    }

    private void generateOutputBatchedArr(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            EventBean[] eventsPerStream = entry.getValue();
            this.aggregationService.setCurrentRow(entry.getKey());
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (!this.isSorting) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.exprEvaluatorContext));
        }
    }

    private void generateOutputBatchedView(EventBean[] outputEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            eventsPerStream[0] = outputEvents[count];
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (this.isSorting) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.exprEvaluatorContext));
            }
            ++count;
        }
    }

    private void generateOutputBatchedJoin(Set<MultiKey<EventBean>> outputEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            this.aggregationService.setCurrentRow(groupByKeys[count]);
            EventBean[] eventsPerStream = row.getArray();
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (this.isSorting) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.exprEvaluatorContext));
            }
            ++count;
        }
    }

    private void generateOutputBatchedView(EventBean[] outputEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<MultiKeyUntyped, EventBean> resultEvents, Map<MultiKeyUntyped, MultiKeyUntyped> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            MultiKeyUntyped groupKey = groupByKeys[count];
            this.aggregationService.setCurrentRow(groupKey);
            eventsPerStream[0] = outputEvents[count];
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (this.isSorting) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.exprEvaluatorContext));
            }
            ++count;
        }
    }

    private void generateOutputBatchedJoin(Set<MultiKey<EventBean>> outputEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<MultiKeyUntyped, EventBean> resultEvents, Map<MultiKeyUntyped, MultiKeyUntyped> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            MultiKeyUntyped groupKey = groupByKeys[count];
            this.aggregationService.setCurrentRow(groupKey);
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(row.getArray(), isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(row.getArray(), isNewData, isSynthesize));
            if (this.isSorting) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(row.getArray(), isNewData, this.exprEvaluatorContext));
            }
            ++count;
        }
    }
}

