/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.TransformEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorBaseSimple;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleTransform;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.view.Viewable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorHandThrough
extends ResultSetProcessorBaseSimple {
    private static final Log log = LogFactory.getLog(ResultSetProcessorHandThrough.class);
    private final boolean isSelectRStream;
    private final SelectExprProcessor selectExprProcessor;
    private final Set<MultiKey<EventBean>> emptyRowSet = new HashSet<MultiKey<EventBean>>();

    public ResultSetProcessorHandThrough(SelectExprProcessor selectExprProcessor, boolean isSelectRStream) {
        this.selectExprProcessor = selectExprProcessor;
        this.isSelectRStream = isSelectRStream;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, oldEvents, false, isSynthesize);
        }
        EventBean[] selectNewEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, newEvents, true, isSynthesize);
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, oldData, false, isSynthesize);
        }
        EventBean[] selectNewEvents = ResultSetProcessorHandThrough.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, isSynthesize);
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor == null ? events[i] : exprProcessor.process(eventsPerStream, isNewData, isSynthesize);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize) {
        int length = events.size();
        if (length == 0) {
            return null;
        }
        EventBean[] result = new EventBean[length];
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize);
            ++count;
        }
        return result;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        return new TransformEventIterator(parent.iterator(), new ResultSetProcessorSimpleTransform(this));
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        UniformPair<EventBean[]> result = this.processJoinResult(joinSet, this.emptyRowSet, true);
        return new ArrayEventIterator(result.getFirst());
    }
}

