/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.NullIterator;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorRowForAll
implements ResultSetProcessor {
    private static final EventBean[] EVENT_PER_STREAM_EMPTY = new EventBean[0];
    private final boolean isSelectRStream;
    private final boolean isUnidirectional;
    private final SelectExprProcessor selectExprProcessor;
    private final AggregationService aggregationService;
    private final OrderByProcessor orderByProcessor;
    private final ExprNode optionalHavingNode;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetProcessorRowForAll(SelectExprProcessor selectExprProcessor, AggregationService aggregationService, OrderByProcessor orderByProcessor, ExprNode optionalHavingNode, boolean isSelectRStream, boolean isUnidirectional, ExprEvaluatorContext exprEvaluatorContext) {
        this.selectExprProcessor = selectExprProcessor;
        this.aggregationService = aggregationService;
        this.optionalHavingNode = optionalHavingNode;
        this.orderByProcessor = orderByProcessor;
        this.isSelectRStream = isSelectRStream;
        this.isUnidirectional = isUnidirectional;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.isUnidirectional) {
            this.clear();
        }
        if (this.isSelectRStream) {
            selectOldEvents = this.getSelectListEvents(false, isSynthesize);
        }
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> events : newEvents) {
                this.aggregationService.applyEnter(events.getArray(), null, this.exprEvaluatorContext);
            }
        }
        if (!oldEvents.isEmpty()) {
            for (MultiKey<EventBean> events : oldEvents) {
                this.aggregationService.applyLeave(events.getArray(), null, this.exprEvaluatorContext);
            }
        }
        if ((selectNewEvents = this.getSelectListEvents(true, isSynthesize)) == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = this.getSelectListEvents(false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
            }
        }
        if ((selectNewEvents = this.getSelectListEvents(true, isSynthesize)) == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    private EventBean[] getSelectListEvents(boolean isNewData, boolean isSynthesize) {
        Boolean result;
        EventBean event = this.selectExprProcessor.process(EVENT_PER_STREAM_EMPTY, isNewData, isSynthesize);
        if (!(this.optionalHavingNode == null || (result = (Boolean)this.optionalHavingNode.evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return null;
        }
        return new EventBean[]{event};
    }

    private EventBean getSelectListEvent(boolean isNewData, boolean isSynthesize) {
        Boolean result;
        EventBean event = this.selectExprProcessor.process(EVENT_PER_STREAM_EMPTY, isNewData, isSynthesize);
        if (!(this.optionalHavingNode == null || (result = (Boolean)this.optionalHavingNode.evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return null;
        }
        return event;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        EventBean[] selectNewEvents = this.getSelectListEvents(true, true);
        if (selectNewEvents == null) {
            return new NullIterator<EventBean>();
        }
        return new SingleEventIterator(selectNewEvents[0]);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        EventBean[] result = this.getSelectListEvents(true, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            EventBean[] lastOld;
            EventBean[] eventBeanArray;
            EventBean[] lastNew;
            EventBean[] eventBeanArray2;
            EventBean lastOldEvent = null;
            EventBean lastNewEvent = null;
            if (joinEventsSet.isEmpty()) {
                lastNewEvent = this.isSelectRStream ? (lastOldEvent = this.getSelectListEvent(false, generateSynthetic)) : this.getSelectListEvent(false, generateSynthetic);
            }
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                if (this.isUnidirectional) {
                    this.clear();
                }
                Set<MultiKey<EventBean>> newData = pair.getFirst();
                Set<MultiKey<EventBean>> oldData = pair.getSecond();
                if (lastOldEvent == null && this.isSelectRStream) {
                    lastOldEvent = this.getSelectListEvent(false, generateSynthetic);
                }
                if (newData != null) {
                    for (MultiKey<EventBean> eventsPerStream : newData) {
                        this.aggregationService.applyEnter(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                    }
                }
                if (oldData != null) {
                    for (MultiKey<EventBean> eventsPerStream : oldData) {
                        this.aggregationService.applyLeave(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                    }
                }
                lastNewEvent = this.getSelectListEvent(true, generateSynthetic);
            }
            if (lastNewEvent != null) {
                EventBean[] eventBeanArray3 = new EventBean[1];
                eventBeanArray2 = eventBeanArray3;
                eventBeanArray3[0] = lastNewEvent;
            } else {
                eventBeanArray2 = lastNew = null;
            }
            if (lastOldEvent != null) {
                EventBean[] eventBeanArray4 = new EventBean[1];
                eventBeanArray = eventBeanArray4;
                eventBeanArray4[0] = lastOldEvent;
            } else {
                eventBeanArray = lastOld = null;
            }
            if (lastNew == null && lastOld == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(lastNew, lastOld);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.isSelectRStream) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList newEventsSortKey = null;
        LinkedList oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedList();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            if (this.isUnidirectional) {
                this.clear();
            }
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.isSelectRStream) {
                this.getSelectListEvent(false, generateSynthetic, oldEvents);
            }
            if (newData != null) {
                for (MultiKey<EventBean> row : newData) {
                    this.aggregationService.applyEnter(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> row : oldData) {
                    this.aggregationService.applyLeave(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            this.getSelectListEvent(false, generateSynthetic, newEvents);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (joinEventsSet.isEmpty()) {
            if (this.isSelectRStream) {
                oldEventsArr = this.getSelectListEvents(false, generateSynthetic);
            }
            newEventsArr = this.getSelectListEvents(true, generateSynthetic);
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            EventBean[] lastOld;
            EventBean[] eventBeanArray;
            EventBean[] lastNew;
            EventBean[] eventBeanArray2;
            EventBean lastOldEvent = null;
            EventBean lastNewEvent = null;
            EventBean[] eventsPerStream = new EventBean[1];
            if (viewEventsList.isEmpty()) {
                lastNewEvent = this.isSelectRStream ? (lastOldEvent = this.getSelectListEvent(false, generateSynthetic)) : this.getSelectListEvent(false, generateSynthetic);
            }
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                int i$;
                int len$;
                EventBean[] arr$;
                EventBean[] newData = pair.getFirst();
                EventBean[] oldData = pair.getSecond();
                if (lastOldEvent == null && this.isSelectRStream) {
                    lastOldEvent = this.getSelectListEvent(false, generateSynthetic);
                }
                if (newData != null) {
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                    }
                }
                if (oldData != null) {
                    arr$ = oldData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                    }
                }
                lastNewEvent = this.getSelectListEvent(false, generateSynthetic);
            }
            if (lastNewEvent != null) {
                EventBean[] eventBeanArray3 = new EventBean[1];
                eventBeanArray2 = eventBeanArray3;
                eventBeanArray3[0] = lastNewEvent;
            } else {
                eventBeanArray2 = lastNew = null;
            }
            if (lastOldEvent != null) {
                EventBean[] eventBeanArray4 = new EventBean[1];
                eventBeanArray = eventBeanArray4;
                eventBeanArray4[0] = lastOldEvent;
            } else {
                eventBeanArray = lastOld = null;
            }
            if (lastNew == null && lastOld == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(lastNew, lastOld);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.isSelectRStream) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList newEventsSortKey = null;
        LinkedList oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedList();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int i$;
            int len$;
            EventBean[] arr$;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (this.isSelectRStream) {
                this.getSelectListEvent(false, generateSynthetic, oldEvents);
            }
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                arr$ = newData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = arr$[i$];
                    this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                arr$ = oldData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = arr$[i$];
                    this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            this.getSelectListEvent(true, generateSynthetic, newEvents);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (viewEventsList.isEmpty()) {
            if (this.isSelectRStream) {
                oldEventsArr = this.getSelectListEvents(false, generateSynthetic);
            }
            newEventsArr = this.getSelectListEvents(true, generateSynthetic);
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private void getSelectListEvent(boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents) {
        Boolean result;
        EventBean event = this.selectExprProcessor.process(EVENT_PER_STREAM_EMPTY, isNewData, isSynthesize);
        if (!(this.optionalHavingNode == null || (result = (Boolean)this.optionalHavingNode.evaluate(null, isNewData, this.exprEvaluatorContext)) != null && result.booleanValue())) {
            return;
        }
        resultEvents.add(event);
    }
}

