/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBean;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import java.util.HashMap;

public class SelectExprJoinWildcardProcessor
implements SelectExprProcessor {
    private final String[] streamNames;
    private final EventType resultEventType;
    private final EventAdapterService eventAdapterService;
    private boolean isPopulateUnderlying;
    private SelectExprInsertEventBean selectExprInsertEventBean;
    private ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprJoinWildcardProcessor(String[] streamNames, EventType[] streamTypes, EventAdapterService eventAdapterService, InsertIntoDesc insertIntoDesc, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (streamNames.length < 2 || streamTypes.length < 2 || streamNames.length != streamTypes.length) {
            throw new IllegalArgumentException("Stream names and types parameter length is invalid, expected use of this class is for join statements");
        }
        this.streamNames = streamNames;
        this.eventAdapterService = eventAdapterService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        HashMap<String, Object> eventTypeMap = new HashMap<String, Object>();
        for (int i = 0; i < streamTypes.length; ++i) {
            eventTypeMap.put(streamNames[i], streamTypes[i]);
        }
        if (insertIntoDesc != null) {
            EventType existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
            if (existingType != null) {
                this.selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(eventAdapterService, existingType);
            }
            if (existingType != null && this.selectExprInsertEventBean != null) {
                this.selectExprInsertEventBean.initializeJoinWildcard(streamNames, streamTypes, methodResolutionService, eventAdapterService);
                this.resultEventType = existingType;
                this.isPopulateUnderlying = true;
            } else {
                try {
                    this.resultEventType = eventAdapterService.addNestableMapType(insertIntoDesc.getEventTypeName(), eventTypeMap, null, false, false, true);
                    selectExprEventTypeRegistry.add(this.resultEventType);
                }
                catch (EventAdapterException ex) {
                    throw new ExprValidationException(ex.getMessage());
                }
            }
        } else {
            this.resultEventType = eventAdapterService.createAnonymousMapType(eventTypeMap);
        }
    }

    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        if (this.isPopulateUnderlying) {
            return this.selectExprInsertEventBean.manufacture(eventsPerStream, isNewData, this.exprEvaluatorContext);
        }
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        for (int i = 0; i < this.streamNames.length; ++i) {
            if (this.streamNames[i] == null) {
                throw new IllegalStateException("Event name for stream " + i + " is null");
            }
            if (eventsPerStream[i] != null) {
                tuple.put(this.streamNames[i], eventsPerStream[i]);
                continue;
            }
            tuple.put(this.streamNames[i], null);
        }
        return this.eventAdapterService.adaptorForTypedMap(tuple, this.resultEventType);
    }

    public EventType getResultEventType() {
        return this.resultEventType;
    }
}

