/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBean;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.eval.EvalInsertMapTypeCoercion;
import com.espertech.esper.epl.core.eval.EvalInsertNative;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcard;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionMap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionMap;
import com.espertech.esper.epl.core.eval.EvalInsertWildcard;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoinRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapperRevision;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcard;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUnderlying;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUnderlying;
import com.espertech.esper.epl.core.eval.EvalSelectWildcard;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprProcessorHelper {
    private static final Log log = LogFactory.getLog(SelectExprProcessorHelper.class);
    private final List<SelectClauseExprCompiledSpec> selectionList;
    private final List<SelectClauseStreamCompiledSpec> selectedStreams;
    private final InsertIntoDesc insertIntoDesc;
    private final boolean isUsingWildcard;
    private final StreamTypeService typeService;
    private final EventAdapterService eventAdapterService;
    private final ValueAddEventService valueAddEventService;
    private final SelectExprEventTypeRegistry selectExprEventTypeRegistry;
    private final MethodResolutionService methodResolutionService;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprProcessorHelper(List<SelectClauseExprCompiledSpec> selectionList, List<SelectClauseStreamCompiledSpec> selectedStreams, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.selectionList = selectionList;
        this.selectedStreams = selectedStreams;
        this.insertIntoDesc = insertIntoDesc;
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        this.typeService = typeService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.valueAddEventService = valueAddEventService;
        this.selectExprEventTypeRegistry = selectExprEventTypeRegistry;
        this.methodResolutionService = methodResolutionService;
    }

    /*
     * WARNING - void declaration
     */
    public SelectExprProcessor getEvaluator() throws ExprValidationException {
        void var12_34;
        int i;
        String[] columnNames;
        ArrayList<SelectClauseStreamCompiledSpec> namedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        ArrayList<SelectClauseStreamCompiledSpec> unnamedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        for (SelectClauseStreamCompiledSpec spec : this.selectedStreams) {
            if (spec.getOptionalName() == null) {
                unnamedStreams.add(spec);
                continue;
            }
            namedStreams.add(spec);
            if (!spec.isProperty()) continue;
            throw new ExprValidationException("The property wildcard syntax must be used without column name");
        }
        if (unnamedStreams.size() > 1) {
            throw new ExprValidationException("A column name must be supplied for all but one stream if multiple streams are selected via the stream.* notation");
        }
        if (this.selectedStreams.isEmpty() && this.selectionList.isEmpty() && !this.isUsingWildcard) {
            throw new IllegalArgumentException("Empty selection list not supported");
        }
        for (SelectClauseExprCompiledSpec entry : this.selectionList) {
            if (entry.getAssignedName() != null) continue;
            throw new IllegalArgumentException("Expected name for each expression has not been supplied");
        }
        if (this.insertIntoDesc != null) {
            SelectExprProcessorHelper.verifyInsertInto(this.insertIntoDesc, this.selectionList);
        }
        SelectExprJoinWildcardProcessor joinWildcardProcessor = null;
        if (this.typeService.getStreamNames().length > 1 && this.isUsingWildcard) {
            joinWildcardProcessor = new SelectExprJoinWildcardProcessor(this.typeService.getStreamNames(), this.typeService.getEventTypes(), this.eventAdapterService, null, this.selectExprEventTypeRegistry, this.methodResolutionService, this.exprEvaluatorContext);
        }
        EventType eventType = null;
        boolean singleStreamWrapper = false;
        if (this.isUsingWildcard) {
            if (joinWildcardProcessor != null) {
                eventType = joinWildcardProcessor.getResultEventType();
            } else {
                eventType = this.typeService.getEventTypes()[0];
                if (eventType instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            }
        }
        ExprEvaluator[] expressionNodes = new ExprEvaluator[this.selectionList.size()];
        Object[] expressionReturnTypes = new Object[this.selectionList.size()];
        for (int i2 = 0; i2 < this.selectionList.size(); ++i2) {
            ExprNode expr = this.selectionList.get(i2).getSelectExpression();
            expressionNodes[i2] = expr;
            expressionReturnTypes[i2] = expr.getType();
        }
        if (this.insertIntoDesc != null && !this.insertIntoDesc.getColumnNames().isEmpty()) {
            columnNames = this.insertIntoDesc.getColumnNames().toArray(new String[this.insertIntoDesc.getColumnNames().size()]);
        } else if (!this.selectedStreams.isEmpty()) {
            int numStreamColumnsJoin = 0;
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                numStreamColumnsJoin = this.typeService.getEventTypes().length;
            }
            columnNames = new String[this.selectionList.size() + namedStreams.size() + numStreamColumnsJoin];
            int count = 0;
            for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : this.selectionList) {
                columnNames[count] = selectClauseExprCompiledSpec.getAssignedName();
                ++count;
            }
            for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
                columnNames[count] = selectClauseStreamCompiledSpec.getOptionalName();
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                String[] arr$ = this.typeService.getStreamNames();
                int n = arr$.length;
                for (int i$ = 0; i$ < n; ++i$) {
                    String streamName;
                    columnNames[count] = streamName = arr$[i$];
                    ++count;
                }
            }
        } else {
            columnNames = new String[this.selectionList.size()];
            for (int i3 = 0; i3 < this.selectionList.size(); ++i3) {
                columnNames[i3] = this.selectionList.get(i3).getAssignedName();
            }
        }
        EventType targetType = null;
        if (this.insertIntoDesc != null) {
            targetType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            ExprEvaluator evaluatorFragment;
            EventPropertyGetter getter;
            FragmentEventType fragmentType;
            if (!(expressionNodes[i] instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)expressionNodes[i];
            String string = identNode.getResolvedPropertyName();
            final int streamNum = identNode.getStreamId();
            EventType eventTypeStream = this.typeService.getEventTypes()[streamNum];
            if (eventTypeStream instanceof NativeEventType || (fragmentType = eventTypeStream.getFragmentType(string)) == null || fragmentType.isNative()) continue;
            FragmentEventType targetFragment = null;
            if (targetType != null) {
                targetFragment = targetType.getFragmentType(columnNames[i]);
            }
            if (targetType != null && fragmentType.getFragmentType().getUnderlyingType() == expressionReturnTypes[i] && (targetFragment == null || targetFragment != null && targetFragment.isNative())) {
                getter = eventTypeStream.getGetter(string);
                expressionNodes[i] = evaluatorFragment = new ExprEvaluator(){

                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean streamEvent = eventsPerStream[streamNum];
                        if (streamEvent == null) {
                            return null;
                        }
                        return getter.get(streamEvent);
                    }
                };
                continue;
            }
            getter = eventTypeStream.getGetter(string);
            expressionNodes[i] = evaluatorFragment = new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean streamEvent = eventsPerStream[streamNum];
                    if (streamEvent == null) {
                        return null;
                    }
                    return getter.getFragment(streamEvent);
                }
            };
            expressionReturnTypes[i] = !fragmentType.isIndexed() ? fragmentType.getFragmentType() : new EventType[]{fragmentType.getFragmentType()};
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            ExprEvaluator evaluator;
            if (!(expressionNodes[i] instanceof ExprStreamUnderlyingNode)) continue;
            ExprStreamUnderlyingNode undNode = (ExprStreamUnderlyingNode)expressionNodes[i];
            final int n = undNode.getStreamId();
            EventType eventTypeStream = this.typeService.getEventTypes()[n];
            expressionNodes[i] = evaluator = new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    return eventsPerStream[n];
                }
            };
            expressionReturnTypes[i] = eventTypeStream;
        }
        LinkedHashMap<String, Object> selPropertyTypes = new LinkedHashMap<String, Object>();
        int count = 0;
        for (ExprEvaluator expressionNode : expressionNodes) {
            Object expressionReturnType = expressionReturnTypes[count];
            selPropertyTypes.put(columnNames[count], expressionReturnType);
            ++count;
        }
        if (!this.selectedStreams.isEmpty()) {
            for (SelectClauseStreamCompiledSpec element : namedStreams) {
                EventType eventTypeStream = this.typeService.getEventTypes()[element.getStreamNumber()];
                selPropertyTypes.put(columnNames[count], eventTypeStream);
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                void var12_27;
                boolean bl = false;
                while (var12_27 < this.typeService.getEventTypes().length) {
                    EventType eventTypeStream = this.typeService.getEventTypes()[var12_27];
                    selPropertyTypes.put(columnNames[count], eventTypeStream);
                    ++count;
                    ++var12_27;
                }
            }
        }
        Object var12_28 = null;
        int underlyingStreamNumber = 0;
        boolean underlyingIsFragmentEvent = false;
        EventPropertyGetter underlyingPropertyEventGetter = null;
        if (!(this.selectedStreams.isEmpty() || !this.isUsingWildcard && unnamedStreams.isEmpty())) {
            if (!unnamedStreams.isEmpty()) {
                underlyingStreamNumber = ((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getStreamNumber();
                if (((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).isFragmentEvent()) {
                    EventType compositeMap = this.typeService.getEventTypes()[underlyingStreamNumber];
                    FragmentEventType fragment = compositeMap.getFragmentType(((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getStreamName());
                    EventType eventType2 = fragment.getFragmentType();
                    underlyingIsFragmentEvent = true;
                } else if (((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).isProperty()) {
                    String propertyName = ((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getStreamName();
                    Class propertyType = ((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getPropertyType();
                    int streamNumber = ((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getStreamNumber();
                    if (JavaClassHelper.isJavaBuiltinDataType(((SelectClauseStreamCompiledSpec)unnamedStreams.get(0)).getPropertyType())) {
                        throw new ExprValidationException("The property wildcard syntax cannot be used on built-in types as returned by property '" + propertyName + "'");
                    }
                    EventType eventType3 = this.eventAdapterService.addBeanType(propertyType.getName(), propertyType, false);
                    this.selectExprEventTypeRegistry.add(eventType3);
                    underlyingPropertyEventGetter = this.typeService.getEventTypes()[streamNumber].getGetter(propertyName);
                    if (underlyingPropertyEventGetter == null) {
                        throw new ExprValidationException("Unexpected error resolving property getter for property " + propertyName);
                    }
                } else {
                    EventType eventType4 = this.typeService.getEventTypes()[underlyingStreamNumber];
                }
            } else if (this.typeService.getEventTypes().length == 1) {
                EventType eventType5 = this.typeService.getEventTypes()[0];
                if (eventType5 instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            } else {
                Object var12_33 = null;
            }
        }
        SelectExprContext selectExprContext = new SelectExprContext(expressionNodes, columnNames, this.exprEvaluatorContext, this.eventAdapterService);
        if (this.insertIntoDesc == null) {
            EventType resultEventType;
            if (!this.selectedStreams.isEmpty()) {
                if (var12_34 != null) {
                    resultEventType = this.eventAdapterService.createAnonymousWrapperType((EventType)var12_34, selPropertyTypes);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, (EventType)var12_34, singleStreamWrapper, underlyingIsFragmentEvent, underlyingStreamNumber, underlyingPropertyEventGetter);
                }
                resultEventType = this.eventAdapterService.createAnonymousMapType(selPropertyTypes);
                return new EvalSelectStreamNoUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
            }
            if (this.isUsingWildcard) {
                resultEventType = this.eventAdapterService.createAnonymousWrapperType(eventType, selPropertyTypes);
                if (singleStreamWrapper) {
                    return new EvalSelectWildcardSSWrapper(selectExprContext, resultEventType);
                }
                if (joinWildcardProcessor == null) {
                    return new EvalSelectWildcard(selectExprContext, resultEventType);
                }
                return new EvalSelectWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
            }
            resultEventType = this.eventAdapterService.createAnonymousMapType(selPropertyTypes);
            return new EvalSelectNoWildcard(selectExprContext, resultEventType);
        }
        EventType vaeInnerEventType = null;
        boolean singleColumnCoercion = false;
        boolean isRevisionEvent = false;
        try {
            EventType existingType;
            if (!this.selectedStreams.isEmpty()) {
                if (var12_34 != null) {
                    EventType resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), (EventType)var12_34, selPropertyTypes, false, true);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, (EventType)var12_34, singleStreamWrapper, underlyingIsFragmentEvent, underlyingStreamNumber, underlyingPropertyEventGetter);
                }
                EventType resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, true);
                return new EvalSelectStreamNoUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
            }
            ValueAddEventProcessor vaeProcessor = this.valueAddEventService.getValueAddProcessor(this.insertIntoDesc.getEventTypeName());
            if (this.isUsingWildcard) {
                EventType resultEventType;
                if (vaeProcessor != null) {
                    resultEventType = vaeProcessor.getValueAddEventType();
                    isRevisionEvent = true;
                    vaeProcessor.validateEventType(eventType);
                } else {
                    EventType existingType2 = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
                    SelectExprInsertEventBean selectExprInsertEventBean = null;
                    if (existingType2 != null) {
                        selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(this.eventAdapterService, existingType2);
                    }
                    if (existingType2 != null && selectExprInsertEventBean != null) {
                        selectExprInsertEventBean.initialize(this.isUsingWildcard, this.typeService, expressionNodes, columnNames, expressionReturnTypes, this.methodResolutionService, this.eventAdapterService);
                        EventType resultEventType2 = existingType2;
                        return new EvalInsertNative(resultEventType2, selectExprInsertEventBean, this.exprEvaluatorContext);
                    }
                    if (existingType2 != null && selPropertyTypes.isEmpty() && existingType2 instanceof MapEventType) {
                        EventType resultEventType3 = existingType2;
                        return new EvalInsertMapTypeCoercion(resultEventType3, this.eventAdapterService);
                    }
                    resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), eventType, selPropertyTypes, false, true);
                }
                if (singleStreamWrapper) {
                    if (!isRevisionEvent) {
                        return new EvalInsertWildcardSSWrapper(selectExprContext, resultEventType);
                    }
                    return new EvalInsertWildcardSSWrapperRevision(selectExprContext, resultEventType, vaeProcessor);
                }
                if (joinWildcardProcessor == null) {
                    if (!isRevisionEvent) {
                        return new EvalInsertWildcard(selectExprContext, resultEventType);
                    }
                    return new EvalInsertWildcardRevision(selectExprContext, resultEventType, vaeProcessor);
                }
                if (!isRevisionEvent) {
                    return new EvalInsertWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
                }
                return new EvalInsertWildcardJoinRevision(selectExprContext, resultEventType, joinWildcardProcessor, vaeProcessor);
            }
            EventType resultEventType = null;
            if (columnNames.length == 1 && this.insertIntoDesc.getColumnNames().size() == 0 && (existingType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName())) != null) {
                WrapperEventType wrapperType;
                Object columnOneType = expressionReturnTypes[0];
                if (existingType instanceof WrapperEventType && (wrapperType = (WrapperEventType)existingType).getUnderlyingEventType().getUnderlyingType() == columnOneType) {
                    singleColumnCoercion = true;
                    resultEventType = existingType;
                }
            }
            if (resultEventType == null) {
                if (vaeProcessor != null) {
                    resultEventType = this.eventAdapterService.createAnonymousMapType(selPropertyTypes);
                } else {
                    existingType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
                    SelectExprInsertEventBean selectExprInsertEventBean = null;
                    if (existingType != null) {
                        selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(this.eventAdapterService, existingType);
                    }
                    if (existingType != null && selectExprInsertEventBean != null) {
                        selectExprInsertEventBean.initialize(this.isUsingWildcard, this.typeService, expressionNodes, columnNames, expressionReturnTypes, this.methodResolutionService, this.eventAdapterService);
                        resultEventType = existingType;
                        return new EvalInsertNative(resultEventType, selectExprInsertEventBean, this.exprEvaluatorContext);
                    }
                    resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, true);
                }
            }
            if (vaeProcessor != null) {
                vaeProcessor.validateEventType(resultEventType);
                vaeInnerEventType = resultEventType;
                resultEventType = vaeProcessor.getValueAddEventType();
                isRevisionEvent = true;
            }
            if (singleColumnCoercion) {
                if (!isRevisionEvent) {
                    if (resultEventType instanceof MapEventType) {
                        return new EvalInsertNoWildcardSingleColCoercionMap(selectExprContext, resultEventType);
                    }
                    return new EvalInsertNoWildcardSingleColCoercionBean(selectExprContext, resultEventType);
                }
                if (resultEventType instanceof MapEventType) {
                    return new EvalInsertNoWildcardSingleColCoercionRevisionMap(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
                }
                return new EvalInsertNoWildcardSingleColCoercionRevisionBean(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
            }
            if (!isRevisionEvent) {
                return new EvalInsertNoWildcard(selectExprContext, resultEventType);
            }
            return new EvalInsertNoWildcardRevision(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
        }
        catch (EventAdapterException ex) {
            throw new ExprValidationException(ex.getMessage());
        }
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectClauseExprCompiledSpec> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

