/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.core.BindProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.NaturalEventBean;

public class SelectExprResultProcessor
implements SelectExprProcessor {
    private final StatementResultService statementResultService;
    private final SelectExprProcessor syntheticProcessor;
    private final BindProcessor bindProcessor;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprResultProcessor(StatementResultService statementResultService, SelectExprProcessor syntheticProcessor, BindProcessor bindProcessor, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.statementResultService = statementResultService;
        this.syntheticProcessor = syntheticProcessor;
        this.bindProcessor = bindProcessor;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    public EventType getResultEventType() {
        return this.syntheticProcessor.getResultEventType();
    }

    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        if (isSynthesize && !this.statementResultService.isMakeNatural()) {
            return this.syntheticProcessor.process(eventsPerStream, isNewData, isSynthesize);
        }
        EventBean syntheticEvent = null;
        EventType syntheticEventType = null;
        if (this.statementResultService.isMakeSynthetic() || isSynthesize) {
            syntheticEvent = this.syntheticProcessor.process(eventsPerStream, isNewData, isSynthesize);
            if (!this.statementResultService.isMakeNatural()) {
                return syntheticEvent;
            }
            syntheticEventType = this.syntheticProcessor.getResultEventType();
        }
        if (!this.statementResultService.isMakeNatural()) {
            return null;
        }
        Object[] parameters = this.bindProcessor.process(eventsPerStream, isNewData, this.exprEvaluatorContext);
        return new NaturalEventBean(syntheticEventType, parameters, syntheticEvent);
    }
}

