/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.DuplicatePropertyException;
import com.espertech.esper.epl.core.PropertyNotFoundException;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamNotFoundException;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.util.LevenshteinDistance;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamTypeServiceImpl
implements StreamTypeService {
    private final EventType[] eventTypes;
    private final String[] streamNames;
    private final boolean[] isIStreamOnly;
    private final String engineURIQualifier;
    private boolean isStreamZeroUnambigous;
    private boolean requireStreamNames;

    public StreamTypeServiceImpl(String engineURI) {
        this(new EventType[0], new String[0], new boolean[0], engineURI);
    }

    public StreamTypeServiceImpl(EventType eventType, String streamName, boolean isIStreamOnly, String engineURI) {
        this(new EventType[]{eventType}, new String[]{streamName}, new boolean[]{isIStreamOnly}, engineURI);
    }

    public StreamTypeServiceImpl(EventType[] eventTypes, String[] streamNames, boolean[] isIStreamOnly, String engineURI) {
        this.eventTypes = eventTypes;
        this.streamNames = streamNames;
        this.isIStreamOnly = isIStreamOnly;
        this.engineURIQualifier = engineURI == null || "default".equals(engineURI) ? "default" : engineURI;
        if (eventTypes.length != streamNames.length) {
            throw new IllegalArgumentException("Number of entries for event types and stream names differs");
        }
    }

    public StreamTypeServiceImpl(LinkedHashMap<String, Pair<EventType, String>> namesAndTypes, String engineURI, boolean isStreamZeroUnambigous, boolean requireStreamNames) {
        this.isStreamZeroUnambigous = isStreamZeroUnambigous;
        this.requireStreamNames = requireStreamNames;
        this.engineURIQualifier = engineURI;
        this.isIStreamOnly = new boolean[namesAndTypes.size()];
        this.eventTypes = new EventType[namesAndTypes.size()];
        this.streamNames = new String[namesAndTypes.size()];
        int count = 0;
        for (Map.Entry<String, Pair<EventType, String>> entry : namesAndTypes.entrySet()) {
            this.streamNames[count] = entry.getKey();
            this.eventTypes[count] = entry.getValue().getFirst();
            ++count;
        }
    }

    @Override
    public EventType[] getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public String[] getStreamNames() {
        return this.streamNames;
    }

    @Override
    public boolean[] getIStreamOnly() {
        return this.isIStreamOnly;
    }

    @Override
    public PropertyResolutionDescriptor resolveByPropertyName(String propertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        PropertyResolutionDescriptor desc = this.findByPropertyName(propertyName);
        if (this.requireStreamNames && desc.getStreamNum() != 0) {
            throw new PropertyNotFoundException("Property named '" + propertyName + "' must be prefixed by a stream name, use the stream name itself or use the as-clause to name the stream with the property in the format \"stream.property\"", null);
        }
        return desc;
    }

    @Override
    public PropertyResolutionDescriptor resolveByStreamAndPropName(String streamName, String propertyName) throws PropertyNotFoundException, StreamNotFoundException {
        if (streamName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        return this.findByStreamAndEngineName(propertyName, streamName);
    }

    @Override
    public PropertyResolutionDescriptor resolveByStreamAndPropName(String streamAndPropertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        PropertyResolutionDescriptor desc2;
        if (streamAndPropertyName == null) {
            throw new IllegalArgumentException("Null stream and property name");
        }
        try {
            desc2 = this.findByPropertyName(streamAndPropertyName);
        }
        catch (PropertyNotFoundException ex) {
            PropertyResolutionDescriptor desc2;
            int index = ASTFilterSpecHelper.unescapedIndexOfDot(streamAndPropertyName);
            if (index == -1) {
                throw ex;
            }
            String streamName = streamAndPropertyName.substring(0, index);
            String propertyName = streamAndPropertyName.substring(index + 1, streamAndPropertyName.length());
            try {
                desc2 = this.findByStreamAndEngineName(propertyName, streamName);
            }
            catch (StreamNotFoundException e2) {
                Pair<String, String> propertyNoEnginePair = this.getIsEngineQualified(propertyName, streamName);
                if (propertyNoEnginePair == null) {
                    throw ex;
                }
                try {
                    return this.findByStreamNameOnly(propertyNoEnginePair.getFirst(), propertyNoEnginePair.getSecond());
                }
                catch (StreamNotFoundException e1) {
                    throw ex;
                }
            }
            return desc2;
        }
        return desc2;
    }

    private PropertyResolutionDescriptor findByPropertyName(String propertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        int index = 0;
        int foundIndex = 0;
        int foundCount = 0;
        EventType streamType = null;
        for (int i = 0; i < this.eventTypes.length; ++i) {
            if (this.eventTypes[i] != null && this.eventTypes[i].isProperty(propertyName)) {
                streamType = this.eventTypes[i];
                ++foundCount;
                foundIndex = index;
                if (i == 0 && this.isStreamZeroUnambigous) {
                    return new PropertyResolutionDescriptor(this.streamNames[0], this.eventTypes[0], propertyName, 0, streamType.getPropertyType(propertyName));
                }
            }
            ++index;
        }
        if (foundCount > 1) {
            throw new DuplicatePropertyException("Property named '" + propertyName + "' is ambigous as is valid for more then one stream");
        }
        if (streamType == null) {
            Pair<Integer, String> possibleMatch = this.findLevMatch(propertyName);
            String message = "Property named '" + propertyName + "' is not valid in any stream";
            throw new PropertyNotFoundException(message, possibleMatch);
        }
        return new PropertyResolutionDescriptor(this.streamNames[foundIndex], this.eventTypes[foundIndex], propertyName, foundIndex, streamType.getPropertyType(propertyName));
    }

    private Pair<Integer, String> findLevMatch(String propertyName) {
        String bestMatch = null;
        int bestMatchDiff = Integer.MAX_VALUE;
        for (int i = 0; i < this.eventTypes.length; ++i) {
            if (this.eventTypes[i] == null) continue;
            EventPropertyDescriptor[] props = this.eventTypes[i].getPropertyDescriptors();
            for (int j = 0; j < props.length; ++j) {
                int diff = LevenshteinDistance.computeLevenshteinDistance(propertyName, props[j].getPropertyName());
                if (diff >= bestMatchDiff) continue;
                bestMatchDiff = diff;
                bestMatch = props[j].getPropertyName();
            }
        }
        if (bestMatchDiff < Integer.MAX_VALUE) {
            return new Pair<Integer, Object>(bestMatchDiff, bestMatch);
        }
        return null;
    }

    private Pair<Integer, String> findLevMatch(String propertyName, EventType eventType) {
        String bestMatch = null;
        int bestMatchDiff = Integer.MAX_VALUE;
        EventPropertyDescriptor[] props = eventType.getPropertyDescriptors();
        for (int j = 0; j < props.length; ++j) {
            int diff = LevenshteinDistance.computeLevenshteinDistance(propertyName, props[j].getPropertyName());
            if (diff >= bestMatchDiff) continue;
            bestMatchDiff = diff;
            bestMatch = props[j].getPropertyName();
        }
        if (bestMatchDiff < Integer.MAX_VALUE) {
            return new Pair<Integer, Object>(bestMatchDiff, bestMatch);
        }
        return null;
    }

    private PropertyResolutionDescriptor findByStreamAndEngineName(String propertyName, String streamName) throws PropertyNotFoundException, StreamNotFoundException {
        PropertyResolutionDescriptor desc;
        try {
            desc = this.findByStreamNameOnly(propertyName, streamName);
        }
        catch (PropertyNotFoundException ex) {
            Pair<String, String> propertyNoEnginePair = this.getIsEngineQualified(propertyName, streamName);
            if (propertyNoEnginePair == null) {
                throw ex;
            }
            return this.findByStreamNameOnly(propertyNoEnginePair.getFirst(), propertyNoEnginePair.getSecond());
        }
        catch (StreamNotFoundException ex) {
            Pair<String, String> propertyNoEnginePair = this.getIsEngineQualified(propertyName, streamName);
            if (propertyNoEnginePair == null) {
                throw ex;
            }
            return this.findByStreamNameOnly(propertyNoEnginePair.getFirst(), propertyNoEnginePair.getSecond());
        }
        return desc;
    }

    private Pair<String, String> getIsEngineQualified(String propertyName, String streamName) {
        if (!streamName.equals(this.engineURIQualifier)) {
            return null;
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            return null;
        }
        String streamNameNoEngine = propertyName.substring(0, index);
        String propertyNameNoEngine = propertyName.substring(index + 1, propertyName.length());
        return new Pair<String, String>(propertyNameNoEngine, streamNameNoEngine);
    }

    private PropertyResolutionDescriptor findByStreamNameOnly(String propertyName, String streamName) throws PropertyNotFoundException, StreamNotFoundException {
        int index = 0;
        EventType streamType = null;
        for (int i = 0; i < this.eventTypes.length; ++i) {
            if (this.eventTypes[i] == null) {
                ++index;
                continue;
            }
            if (this.streamNames[i] != null && this.streamNames[i].equals(streamName)) {
                streamType = this.eventTypes[i];
                break;
            }
            if (this.eventTypes[i].getName() != null && this.eventTypes[i].getName().equals(streamName)) {
                streamType = this.eventTypes[i];
                break;
            }
            ++index;
        }
        if (streamType == null) {
            String bestMatch = null;
            int bestMatchDiff = Integer.MAX_VALUE;
            for (int i = 0; i < this.eventTypes.length; ++i) {
                int diff;
                if (this.streamNames[i] != null && (diff = LevenshteinDistance.computeLevenshteinDistance(this.streamNames[i], streamName)) < bestMatchDiff) {
                    bestMatchDiff = diff;
                    bestMatch = this.streamNames[i];
                }
                if (this.eventTypes[i] == null || this.eventTypes[i].getName() == null || (diff = LevenshteinDistance.computeLevenshteinDistance(this.eventTypes[i].getName(), streamName)) >= bestMatchDiff) continue;
                bestMatchDiff = diff;
                bestMatch = this.eventTypes[i].getName();
            }
            Pair<Integer, Object> suggestion = null;
            if (bestMatchDiff < Integer.MAX_VALUE) {
                suggestion = new Pair<Integer, Object>(bestMatchDiff, bestMatch);
            }
            throw new StreamNotFoundException("Failed to find a stream named '" + streamName + "'", suggestion);
        }
        Class propertyType = streamType.getPropertyType(propertyName);
        if (propertyType == null) {
            Pair<Integer, String> possibleMatch = this.findLevMatch(propertyName, streamType);
            String message = "Property named '" + propertyName + "' is not valid in stream '" + streamName + "'";
            throw new PropertyNotFoundException(message, possibleMatch);
        }
        return new PropertyResolutionDescriptor(streamName, streamType, propertyName, index, propertyType);
    }
}

