/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.event.EventAdapterService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvalBase
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(EvalBase.class);
    private final SelectExprContext selectExprContext;
    private final EventType resultEventType;

    public EvalBase(SelectExprContext selectExprContext, EventType resultEventType) {
        this.selectExprContext = selectExprContext;
        this.resultEventType = resultEventType;
    }

    public abstract EventBean processSpecific(Map<String, Object> var1, EventBean[] var2, boolean var3, boolean var4);

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        HashMap<String, Object> props;
        ExprEvaluator[] expressionNodes = this.selectExprContext.getExpressionNodes();
        String[] columnNames = this.selectExprContext.getColumnNames();
        ExprEvaluatorContext exprEvaluatorContext = this.selectExprContext.getExprEvaluatorContext();
        if (expressionNodes.length == 0) {
            props = Collections.EMPTY_MAP;
        } else {
            props = new HashMap<String, Object>();
            for (int i = 0; i < expressionNodes.length; ++i) {
                Object evalResult = expressionNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                props.put(columnNames[i], evalResult);
            }
        }
        return this.processSpecific(props, eventsPerStream, isNewData, isSynthesize);
    }

    public EventAdapterService getEventAdapterService() {
        return this.selectExprContext.getEventAdapterService();
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }

    public String getFirstColumnName() {
        return this.selectExprContext.getColumnNames()[0];
    }

    public ExprEvaluator[] getExprNodes() {
        return this.selectExprContext.getExpressionNodes();
    }
}

