/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.client.ConfigurationExpiryTimeCache;
import com.espertech.esper.client.ConfigurationLRUCache;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheExpiringImpl;
import com.espertech.esper.epl.db.DataCacheLRUImpl;
import com.espertech.esper.epl.db.DataCacheNullImpl;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;

public class DataCacheFactory {
    public static DataCache getDataCache(ConfigurationDataCache cacheDesc, EPStatementHandle epStatementHandle, SchedulingService schedulingService, ScheduleBucket scheduleBucket) {
        if (cacheDesc == null) {
            return new DataCacheNullImpl();
        }
        if (cacheDesc instanceof ConfigurationLRUCache) {
            ConfigurationLRUCache lruCache = (ConfigurationLRUCache)cacheDesc;
            return new DataCacheLRUImpl(lruCache.getSize());
        }
        if (cacheDesc instanceof ConfigurationExpiryTimeCache) {
            ConfigurationExpiryTimeCache expCache = (ConfigurationExpiryTimeCache)cacheDesc;
            return new DataCacheExpiringImpl(expCache.getMaxAgeSeconds(), expCache.getPurgeIntervalSeconds(), expCache.getCacheReferenceType(), schedulingService, scheduleBucket.allocateSlot(), epStatementHandle);
        }
        throw new IllegalStateException("Cache implementation class not configured");
    }
}

