/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.SQLColumnTypeConversion;
import com.espertech.esper.client.hook.SQLColumnValueContext;
import com.espertech.esper.client.hook.SQLInputParameterContext;
import com.espertech.esper.client.hook.SQLOutputRowConversion;
import com.espertech.esper.client.hook.SQLOutputRowValueContext;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.db.ConnectionCache;
import com.espertech.esper.epl.db.DBOutputTypeDesc;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.util.DatabaseTypeBinding;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollExecStrategyDBQuery
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(PollExecStrategyDBQuery.class);
    private final EventAdapterService eventAdapterService;
    private final String preparedStatementText;
    private final Map<String, DBOutputTypeDesc> outputTypes;
    private final ConnectionCache connectionCache;
    private final EventType eventType;
    private final SQLColumnTypeConversion columnTypeConversionHook;
    private final SQLOutputRowConversion outputRowConversionHook;
    private Pair<Connection, PreparedStatement> resources;

    public PollExecStrategyDBQuery(EventAdapterService eventAdapterService, EventType eventType, ConnectionCache connectionCache, String preparedStatementText, Map<String, DBOutputTypeDesc> outputTypes, SQLColumnTypeConversion columnTypeConversionHook, SQLOutputRowConversion outputRowConversionHook) {
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
        this.connectionCache = connectionCache;
        this.preparedStatementText = preparedStatementText;
        this.outputTypes = outputTypes;
        this.columnTypeConversionHook = columnTypeConversionHook;
        this.outputRowConversionHook = outputRowConversionHook;
    }

    @Override
    public void start() {
        this.resources = this.connectionCache.getConnection();
    }

    @Override
    public void done() {
        this.connectionCache.doneWith(this.resources);
    }

    @Override
    public void destroy() {
        this.connectionCache.destroy();
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues) {
        List<EventBean> result;
        try {
            result = this.execute(this.resources.getSecond(), lookupValues);
        }
        catch (EPException ex) {
            this.connectionCache.doneWith(this.resources);
            throw ex;
        }
        return result;
    }

    private List<EventBean> execute(PreparedStatement preparedStatement, Object[] lookupValuePerStream) {
        ResultSet resultSet;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isInfoEnabled()) {
            log.info(".execute Executing prepared statement '" + this.preparedStatementText + "'");
        }
        SQLInputParameterContext inputParameterContext = null;
        if (this.columnTypeConversionHook != null) {
            inputParameterContext = new SQLInputParameterContext();
        }
        int count = 1;
        for (int i = 0; i < lookupValuePerStream.length; ++i) {
            try {
                Object parameter = lookupValuePerStream[i];
                if (ExecutionPathDebugLog.isDebugEnabled && log.isInfoEnabled()) {
                    log.info(".execute Setting parameter " + count + " to " + parameter + " typed " + (parameter == null ? "null" : parameter.getClass()));
                }
                if (this.columnTypeConversionHook != null) {
                    inputParameterContext.setParameterNumber(i + 1);
                    inputParameterContext.setParameterValue(parameter);
                    parameter = this.columnTypeConversionHook.getParameterValue(inputParameterContext);
                }
                this.setObject(preparedStatement, count, parameter);
            }
            catch (SQLException ex) {
                throw new EPException("Error setting parameter " + count, ex);
            }
            ++count;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException ex) {
            throw new EPException("Error executing statement '" + this.preparedStatementText + '\'', ex);
        }
        LinkedList<EventBean> rows = new LinkedList<EventBean>();
        try {
            SQLColumnValueContext valueContext = null;
            if (this.columnTypeConversionHook != null) {
                valueContext = new SQLColumnValueContext();
            }
            SQLOutputRowValueContext rowContext = null;
            if (this.outputRowConversionHook != null) {
                rowContext = new SQLOutputRowValueContext();
            }
            int rowNum = 0;
            while (resultSet.next()) {
                int colNum = 1;
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Map.Entry<String, DBOutputTypeDesc> entry : this.outputTypes.entrySet()) {
                    String columnName = entry.getKey();
                    DatabaseTypeBinding binding = entry.getValue().getOptionalBinding();
                    Object value = binding != null ? binding.getValue(resultSet, columnName) : resultSet.getObject(columnName);
                    if (this.columnTypeConversionHook != null) {
                        valueContext.setColumnName(columnName);
                        valueContext.setColumnNumber(colNum);
                        valueContext.setColumnValue(value);
                        valueContext.setResultSet(resultSet);
                        value = this.columnTypeConversionHook.getColumnValue(valueContext);
                    }
                    row.put(columnName, value);
                    ++colNum;
                }
                EventBean eventBeanRow = null;
                if (this.outputRowConversionHook == null) {
                    eventBeanRow = this.eventAdapterService.adaptorForTypedMap(row, this.eventType);
                } else {
                    rowContext.setValues(row);
                    rowContext.setRowNum(rowNum);
                    rowContext.setResultSet(resultSet);
                    Object rowData = this.outputRowConversionHook.getOutputRow(rowContext);
                    if (rowData != null) {
                        eventBeanRow = this.eventAdapterService.adapterForTypedBean(rowData, (BeanEventType)this.eventType);
                    }
                }
                if (eventBeanRow == null) continue;
                rows.add(eventBeanRow);
                ++rowNum;
            }
        }
        catch (SQLException ex) {
            throw new EPException("Error reading results for statement '" + this.preparedStatementText + '\'', ex);
        }
        try {
            resultSet.close();
        }
        catch (SQLException ex) {
            throw new EPException("Error closing statement '" + this.preparedStatementText + '\'', ex);
        }
        return rows;
    }

    private void setObject(PreparedStatement preparedStatement, int column, Object value) throws SQLException {
        if (value instanceof Date) {
            value = new Timestamp(((Date)value).getTime());
        } else if (value instanceof Calendar) {
            value = new Timestamp(((Calendar)value).getTimeInMillis());
        }
        preparedStatement.setObject(column, value);
    }
}

