/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationResultFuture;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprAggregateNode
extends ExprNode {
    private AggregationResultFuture aggregationResultFuture;
    private int column;
    private AggregationMethod aggregationMethod;
    protected boolean isDistinct;

    protected abstract String getAggregationFunctionName();

    protected abstract boolean equalsNodeAggregate(ExprAggregateNode var1);

    protected abstract AggregationMethod validateAggregationChild(StreamTypeService var1, MethodResolutionService var2, ExprEvaluatorContext var3) throws ExprValidationException;

    protected ExprAggregateNode(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.aggregationMethod = this.validateAggregationChild(streamTypeService, methodResolutionService, exprEvaluatorContext);
        Class childType = null;
        if (this.getChildNodes().size() > 0) {
            childType = this.getChildNodes().get(0).getType();
        }
        if (this.isDistinct) {
            this.aggregationMethod = methodResolutionService.makeDistinctAggregator(this.aggregationMethod, childType);
        }
    }

    @Override
    public Class getType() {
        if (this.aggregationMethod == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethod.getValueType();
    }

    public AggregationMethod getPrototypeAggregator() {
        if (this.aggregationMethod == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethod;
    }

    public void setAggregationResultFuture(AggregationResultFuture aggregationResultFuture, int column) {
        this.aggregationResultFuture = aggregationResultFuture;
        this.column = column;
    }

    @Override
    public final Object evaluate(EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregationResultFuture.getValue(this.column);
    }

    public static void getAggregatesBottomUp(ExprNode topNode, List<ExprAggregateNode> aggregateNodes) {
        int deepLevel;
        TreeMap<Integer, List<ExprAggregateNode>> aggregateExprPerLevel = new TreeMap<Integer, List<ExprAggregateNode>>();
        ExprAggregateNode.recursiveAggregateEnter(topNode, aggregateExprPerLevel, 1);
        if (aggregateExprPerLevel.isEmpty()) {
            return;
        }
        for (int i = deepLevel = aggregateExprPerLevel.lastKey().intValue(); i >= 1; --i) {
            List<ExprAggregateNode> list = aggregateExprPerLevel.get(i);
            if (list == null) continue;
            aggregateNodes.addAll(list);
        }
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public final boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprAggregateNode)) {
            return false;
        }
        ExprAggregateNode other = (ExprAggregateNode)node;
        if (other.isDistinct != this.isDistinct) {
            return false;
        }
        return this.equalsNodeAggregate(other);
    }

    private static void recursiveAggregateEnter(ExprNode currentNode, Map<Integer, List<ExprAggregateNode>> aggregateExprPerLevel, int currentLevel) {
        for (ExprNode node : currentNode.getChildNodes()) {
            ExprAggregateNode.recursiveAggregateEnter(node, aggregateExprPerLevel, currentLevel + 1);
        }
        if (!(currentNode instanceof ExprAggregateNode)) {
            return;
        }
        List<ExprAggregateNode> aggregates = aggregateExprPerLevel.get(currentLevel);
        if (aggregates == null) {
            aggregates = new LinkedList<ExprAggregateNode>();
            aggregateExprPerLevel.put(currentLevel, aggregates);
        }
        aggregates.add((ExprAggregateNode)currentNode);
    }

    protected final Class validateSingleNumericChild(StreamTypeService streamTypeService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException(this.getAggregationFunctionName() + " node must have exactly 1 child node");
        }
        ExprNode child = this.getChildNodes().get(0);
        Class childType = child.getType();
        if (!JavaClassHelper.isNumeric(childType)) {
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        return childType;
    }

    @Override
    public final String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getAggregationFunctionName());
        buffer.append('(');
        if (this.isDistinct) {
            buffer.append("distinct ");
        }
        if (!this.getChildNodes().isEmpty()) {
            buffer.append(this.getChildNodes().get(0).toExpressionString());
        } else {
            buffer.append('*');
        }
        buffer.append(')');
        return buffer.toString();
    }
}

